$(function () {
    $._requestApi('/home/getVentas', {}, 'GET', function (resolve) {
        if (resolve)
            cargarVentas(resolve)
    }); 
    
});	

function cargarVentas(ventas) {
    var ctx = document.getElementById("ventas").getContext('2d');
    var myChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Setiembre", "Octubre", "Noviembre", "Diciembre"],
            datasets: [{
                label: 'Facturacion del '+ (new Date()).getFullYear(),
                data: [ventas.enero, ventas.febrero, ventas.marzo, ventas.abril, ventas.mayo, ventas.junio, ventas.julio, ventas.agosto ,ventas.setiembre ,ventas.octubre ,ventas.noviembre ,ventas.diciembre],
                backgroundColor: [
                    'rgba(75, 192, 42, 0.2)',
                ],
                borderColor: [
                    'rgba(75, 192, 42, 1)',
                ],
                borderWidth: 2
            }]
        },
        options: {
            maintainAspectRatio: false,
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero:true,
                        callback: function(value) {if (value % 1 === 0) {return value;}}
                    }
                }]
            },
            tooltips: {
                enabled: true,
                mode: 'single',
                callbacks: {
                    label: function(tooltipItems, data) { 
                        return tooltipItems.yLabel + " comprobantes";
                    }
                }
            },
        }
    });  
}