$(function () {

    $('.btn_desocupar').on('click', function() {

      var id = $(this).data("id");
    
        $('#delete_modal').modal({
            closable: false,
            onApprove : function() {
                sendDelete(id);
            }
        }).modal('show');  
    });     

    function sendDelete(id) {

        var data = {id_hospedar : id};

            $.requestApi('/hospedar/desocupar', data, 'POST', function (resolve) {
              if (resolve) {
                    $.showMessages(resolve, true, APP_URL+'/hospedar/salida/');
                }
           });
            return false;
    };

    $('.button_info_modal').on('click', function() {

        var id = $(this).data("id");
        var data = {id_huesped : id};
        $.requestApi('/huesped/getById', data, 'POST', function (resolve) {
            if (resolve) {
                $('#_1').text(resolve.nombre); 
                $('#_2').text(resolve.dni); 
                $('#_3').text(resolve.genero); 
                $('#_4').text(resolve.fecha_nacimiento); 
                $('#_5').text(resolve.telefono); 
                $('#_6').text(resolve.email); 
                $('#_7').text(resolve.ocupacion); 
                $('#_8').text(resolve.pais); 
                $('#_9').text(resolve.ciudad); 
                $('#_10').text(resolve.razon_social); 
                $('#_11').text(resolve.ruc); 
                $('#_12').text(resolve.direccion_empresa); 
    
                $('#detalles_modal').modal('show'); 
            }
        });
    });       

    $('.btn_reporte').on('click', function() {
        window.open(APP_URL+'/../pdf/listaHuespedes.php', '_blank');
    });
 
});	

/******************************************************************************/
/* Funciones de fechas
/******************************************************************************/

function tiempo_transcurrido(fecha_ingreso) {
    var result = convertDate2Text( fecha_ingreso ); 
    tiempo_transcurrido = result['dif_horas']+" horas";
    if ( result['dif_horas'] <= 0){
        tiempo_transcurrido = "0 horas";
    }
    if ( result['dif_horas'] == 1){
        tiempo_transcurrido = "1 hora";
    }
    if ( result['dif_horas'] >= 24 ){
        dias =  Math.round(result['dif_horas']/24);
        horas = result['dif_horas']%24;

        _dias = dias + " dias";
        _horas = horas + " horas";

        if(dias == 1)
            _dias = dias + " día";

        if(horas == 1)
            _horas = horas + " hora";

        tiempo_transcurrido = _dias+" "+_horas;                                        
    }
    return  tiempo_transcurrido;  
}

function tiempo_transcurrido_fechas(fecha_ingreso, fecha_salida) {
    var result = restaFechas( fecha_ingreso, fecha_salida ); 
    tiempo_transcurrido = result['dif_horas']+" horas";
    if ( result['dif_horas'] <= 0){
        tiempo_transcurrido = "0 horas";
    }
    if ( result['dif_horas'] == 1){
        tiempo_transcurrido = "1 hora";
    }
    if ( result['dif_horas'] >= 24 ){
        dias =  Math.round(result['dif_horas']/24);
        horas = result['dif_horas']%24;

        _dias = dias + " dias";
        _horas = horas + " horas";

        if(dias == 1)
            _dias = dias + " día";

        if(horas == 1)
            _horas = horas + " hora";

        tiempo_transcurrido = _dias+"  "+_horas;                                        
    }
    return  tiempo_transcurrido;  
}

function fecha_ingreso_format(fecha_ingreso) {
    var result = convertDate2Text( fecha_ingreso );
    fecha_ingreso = result['fecha_text']; 
    return  fecha_ingreso;   
}
/*
function fecha_format(fecha) {
    var dateString = fecha.split('-'); 

    return dateString[2]+'/'+dateString[1]+'/'+dateString[0];
}
       */

function convertDate2Text(fecha) {
    var t = fecha.split(/[- :]/);
    var d = new Date(t[0], t[1]-1, t[2], t[3], t[4], t[5]);
    var _d = new Date();
    
    var fin = _d.getTime() - d.getTime();  
    var dif_dias = Math.round(fin / (1000 * 60 * 60 * 24));
    var dif_horas = Math.round(fin / (1000 * 60 * 60));
            
    r = new Array(3);
    r['fecha_text'] = d.toLocaleString("es-CL");
    r['dif_dias'] = dif_dias;
    r['dif_horas'] = dif_horas;
    
    return r;
}

function restaFechas(fecha_ini, fecha_fin) {

    var t1 = fecha_ini.split(/[- :]/);
    var t2 = fecha_fin.split(/[- :]/);
    // Apply each element to the Date function
    var d = new Date(t1[0], t1[1]-1, t1[2], t1[3], t1[4], t1[5]);
    var _d = new Date(t2[0], t2[1]-1, t2[2], t2[3], t2[4], t2[5]);
    
    var fin = _d.getTime() - d.getTime();  
    var dif_dias = Math.round(fin / (1000 * 60 * 60 * 24));
    var dif_horas = Math.round(fin / (1000 * 60 * 60));
            
    r = new Array(3);
    r['fecha_text'] = d.toLocaleString();
    r['dif_dias'] = dif_dias;
    r['dif_horas'] = dif_horas;
    
    return r;
}