$(function () {

	$('.button_activar_modal').on('click', function() {

  		var id = $(this).data("id");
  	
  		$('#activar_modal').modal({
  			closable: false,
		    onApprove : function() {
		    	sendActivar(id);
		    }
  		}).modal('show');  
  	});		  

  	function sendActivar(id) {

	    var data = {id_habitacion : id};

        $.requestApi('/habitacion/activar', data, 'POST', function (resolve) {
	        if (resolve) {
	            $.showMessages(resolve, true, APP_URL+'/hospedar/listar/');
	        }
	    });
        
        return false;
	};

	$('.button_mantener_modal').on('click', function() {

  		var id = $(this).data("id");
  	
  		$('#mantenimiento_modal').modal({
  			closable: false,
		    onApprove : function() {
		    	sendMantener(id);
		    }
  		}).modal('show');  
  	});		  

  	function sendMantener(id) {

	    var data = {id_habitacion : id};

        $.requestApi('/habitacion/mantener', data, 'POST', function (resolve) {
	        if (resolve) {
                $.showMessages(resolve, true, APP_URL+'/hospedar/listar/');
	        }
	    });
        
        return false;
	};

	/*********************************************************************************************************/
	/* Habitaciones Disponibles
	/*********************************************************************************************************/
	$('#buscar_habitacion_disponibles').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	var numero = $('#buscar_habitacion_disponibles').val();
    		buscarTabla(numero, "#tabla_disponibles");
    	}	
	});

	$('#btn_buscar_habitacion_disponibles').on('click', function() {
    	var numero = $('#buscar_habitacion_disponibles').val();
    	buscarTabla(numero, "#tabla_disponibles");
  	});

  	$('#tipo_habitacion_disponibles').change(function() {
		var option= $("option:selected", this).val();
		if (option == "TODOS") {
			resetearTabla("#tabla_disponibles");
		}
		else {
			buscarTabla(option, "#tabla_disponibles");
		}
	});


	/*********************************************************************************************************/
	/* Habitaciones Ocupadas
	/*********************************************************************************************************/
	$('#buscar_habitacion_ocupadas').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	var numero = $('#buscar_habitacion_ocupadas').val();
    		buscarTabla(numero, "#tabla_ocupadas");
    	}	
	});

	$('#btn_buscar_habitacion_ocupadas').on('click', function() {
    	var numero = $('#buscar_habitacion_ocupadas').val();
    	buscarTabla(numero, "#tabla_ocupadas");
  	});

  	$('#tipo_habitacion_ocupadas').change(function() {
		var option= $("option:selected", this).val();
		if (option == "TODOS") {
			resetearTabla("#tabla_ocupadas");
		}
		else {
			buscarTabla(option, "#tabla_ocupadas");
		}
	});
	/*********************************************************************************************************/
	/* Habitaciones Mantenimiento
	/*********************************************************************************************************/
	$('#buscar_habitacion_mantenimiento').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	var numero = $('#buscar_habitacion_mantenimiento').val();
    		buscarTabla(numero, "#tabla_mantenimiento");
    	}	
	});

	$('#btn_buscar_habitacion_mantenimiento').on('click', function() {
    	var numero = $('#buscar_habitacion_mantenimiento').val();
    	buscarTabla(numero, "#tabla_mantenimiento");
  	});

  	$('#tipo_habitacion_mantenimiento').change(function() {
		var option= $("option:selected", this).val();
		if (option == "TODOS") {
			resetearTabla("#tabla_mantenimiento");
		}
		else {
			buscarTabla(option, "#tabla_mantenimiento");
		}
	});	

});


/*********************************************************************************************************/
/* funciones de busqueda
/*********************************************************************************************************/

function buscarTabla(value, id_tabla){
 	var rows = document.querySelectorAll(id_tabla + ' tbody tr');
    for(var i = 0; i < rows.length; i++){
        var showRow = false;
        var row = rows[i];
        row.style.display = 'none';
        for(var x = 0; x < row.childElementCount; x++){
            if(row.children[x].textContent.toLowerCase().indexOf(value.toLowerCase()) > -1){
                showRow = true;
                break;
            }
        }
        if(showRow){
            row.style.display = null;
        }
    }
}

function resetearTabla(id_tabla){
	value = '';
	var rows = document.querySelectorAll(id_tabla + ' tbody tr');
    for(var i = 0; i < rows.length; i++){
        var showRow = false;
        var row = rows[i];
        row.style.display = 'none';
        for(var x = 0; x < row.childElementCount; x++){
            if(row.children[x].textContent.toLowerCase().indexOf(value.toLowerCase().trim()) > -1){
                showRow = true;
                break;
            }
        }
        if(showRow){
            row.style.display = null;
        }
    }
}