$(function () {

	/******************************************************************************/
	/* validacion de TAB 1
	/******************************************************************************/
	$('[data-tab="one"]').form({
		keyboardShortcuts: false,
    	fields: {
		    buscar_dni: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
    	},
    	inline : true,
	});

	$('.tab_two').on('click', function() {
		if ($('[data-tab="one"]').form('is valid')) {
 			var num = $('#buscar_dni').val();
    		buscarDocumentoHuesped(num);
		} else {
			$('[data-tab="one"]').form('validate form');
		}
  	});

  	/******************************************************************************/
	/* buscar cliente con Keypress
	/******************************************************************************/

	$('#buscar_dni').on('keyup', function(){
  		$(this).val($(this).val().trim());
    });

  	$('#buscar_dni').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	if ($('[data-tab="one"]').form('is valid')) {
	 			var num = $('#buscar_dni').val();
	    		buscarDocumentoHuesped(num);
			} else {
				$('[data-tab="one"]').form('validate form');
			}
    	}	
	});

    $('#loading_doc').on('click', function() {
    	if ($('[data-tab="one"]').form('is valid')) {
 			var num = $('#buscar_dni').val();
    		buscarDocumentoHuesped(num);
		} else {
			$('[data-tab="one"]').form('validate form');
		}
  	});

  	function buscarDocumentoHuesped(num){
		$("#loading_doc").addClass('loading');
    	$._requestApi('/huesped/getByDni', {dni : $("#buscar_dni").val() }, 'POST', function (resolve) {
	        if (resolve) {
	        	if (resolve.id_huesped != null) {
		        	$.tab('change tab', 'two');

		        	$('#id_huesped').val(resolve.id_huesped);
		        	$('#nombre').val(resolve.nombre);
		        	$('#dni').val(resolve.dni);
		        	$('#procedencia').val(resolve.ciudad +' - '+resolve.pais);
		        	$('#razon_social').val(resolve.razon_social);
		        	$('#ruc').val(resolve.ruc);
		        }
		        else {

		        	$("#nuevo_dni").val($("#buscar_dni").val()); 
					$("#loader_producto").addClass('active');
					$("#loader_producto").removeClass('disabled');
					$('#nuevo_huesped_modal').modal('show');	

		        	$._requestApi('/cliente/getDniByApi', {numero_documento : $("#buscar_dni").val() }, 'GET', function (resolve) {
				        if (resolve.nombre != null) {
				        	$("#nuevo_nombre").val(resolve.nombre.trim()); 
				        	$("#nuevo_genero").val(resolve.genero.trim()).change(); 
				        	$("#nuevo_fecha_nacimiento").val(resolve.fecha_nacimiento.trim());
				        }
				        else{
				        	$("#nuevo_nombre").val(''); 
				        	$("#nuevo_fecha_nacimiento").val('');
				        }

				        $("#loader_producto").removeClass('active');
						$("#loader_producto").addClass('disabled');
				       
				    });
		        }
	        }
	        $("#loading_doc").removeClass('loading');
	    });
  	}

  	/******************************************************************************/
	/* buscar RUC cliente
	/******************************************************************************/

	$('#numero_documento').on('keyup', function(){
  		$(this).val($(this).val().trim());
    });

  	$('#numero_documento').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	var num = $('#numero_documento').val();
    		buscarRucCliente(num);
    	}	
	});

/*	$('#numero_documento').on('focusout', function(e){
	    var num = $('#numero_documento').val();
    	buscarDocumentoCliente(num);
	});*/

	$('#loading_doc2').on('click', function() {
    	var num = $('#numero_documento').val();
    	buscarRucCliente(num);
  	});

  	function buscarRucCliente(num) 
  	{	
    	if ( num.length == 11  ) // FACTURA
    	{
    		$("#loading_doc2").addClass('loading');
    		$._requestApi('/cliente/getRucByApi', {'numero_documento' : num }, 'GET', function (resolve) {
        		if (resolve.nombre) {
		        	$('#razon_social').val(resolve.nombre);
		        	resolve.direccion !== '-' ? $('#direccion_empresa').val(resolve.direccion) : $('#direccion_empresa').val('');
		        }
		        else {
		        	$('#razon_social').val('');
		        	$('#direccion_empresa').val('');
		        }
		        $("#loading_doc2").removeClass('loading');
        	}, function () {
        		$("#loading_doc2").removeClass('loading');
        	});
    	}

  	}	




	/******************************************************************************/
	/* validacion de modal 2
	/******************************************************************************/
	$('.tab_one').on('click', function() {
    	$.tab('change tab', 'one');
    	$('#id_huesped').val('');
  	});


	/*********************************************************************************************************/
	/* registra datos huesped
	/*********************************************************************************************************/

		/******************************************************************************/
	/* validacion de modal 1
	/******************************************************************************/
	$('[data-tab="two"]').form({
		keyboardShortcuts: false,
    	fields: {
		    adelanto: {
		    	optional: true,
		        rules: [
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },
    	},
    	inline : true,
	});


  	$('.btn_registrar').on('click', function() {
  		
    	if ( $('#id_huesped').val() !== "" && $('#id_habitacion').val() !== "" ) {
    		if ($('[data-tab="two"]').form('is valid')) {

	    		$('#register_modal').modal({
	  				closable: false,
			    	onApprove : function() {
			    		sendForm();
				    }
		  		}).modal('show'); 

		  	} else {
				$('[data-tab="two"]').form('validate form');
			}
		} else {
			swal("Por favor", "Ingrese el DNI del huesped", "warning");
		}
  	});	

  	function sendForm() {
	    var data = {adelanto : $('#adelanto').val(), papeleta : $('#papeleta').val(), id_huesped : $('#id_huesped').val(),  id_habitacion : $('#id_habitacion').val(), motivo : 	$('input[name="motivo"]:checked').next('label').text().toUpperCase() };
        $.requestApi('/hospedar/registrar', data, 'POST', function (resolve) {
	        if (resolve) {
	            $.showMessages(resolve, true, APP_URL+'/hospedar/detalles/'+resolve.id_hospedar);
	        }
	    });
        return false;
	}; 	


  	/*********************************************************************************************************/
	/* modal agregar huesped
	/*********************************************************************************************************/  	

    $.fn.form.settings.rules.docExiste = function(value) {
	  	return (verificaExiste('dni', value) > 0 ? false : true);
	};

	function verificaExiste(field, param) {
     	var count;
     	$.ajax({
     		async: false,
            url: APP_URL+'/huesped/existeCampo',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            dataType: 'json',
            data: { campo: field, valor: param},
            success: function (data) {
                count = data;
            }
        });
        return count;
	};

    $('#frmNuevoHuesped').form({
    	keyboardShortcuts: false,
    	fields: {
	      	nombre: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    dni: {
		        rules: [
		        	{ type : 'docExiste', prompt : 'El numero de documento ya fue registrado'},
		        	{ type : 'empty', prompt : 'Complete este campo'},
		        ]
		    },
		    telefono: {
		    	optional: true,
		        rules: [{ type : 'integer', prompt : 'Ingrese solo números'}]
		    },
		    email: {
		    	optional: true,
		        rules: [{ type : 'email', prompt : 'Ingrese un email válido'}]
		    },
		    razon_social: {
		    	depends: 'ruc',
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    ruc: {
		    	optional: true,
		        rules: [
		        	{ type : 'integer', prompt : 'Ingrese solo numeros'},
		        	{ type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
		        ]
		    },
		    ciudad: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
    	},
    	inline : true,
	});

    $('.btn_registrar_huesped').on('click', function() {
		if ($('#frmNuevoHuesped').form('is valid')) {
			$("#loader_producto").removeClass('disabled');
			$("#loader_producto").addClass('active');
			var data = $('#frmNuevoHuesped').serialize()+'&pais='+$('#pais').dropdown('get text').toUpperCase(); 
	        $._requestApi('/huesped/registrar', data, 'POST', function (resolve) {
		        if (resolve) {
		            if (resolve.message === "success") {
			        	$('#id_huesped').val(resolve.id_huesped);
			        	$('#nombre').val(resolve.nombre);
			        	$('#dni').val(resolve.dni);
			        	$('#procedencia').val(resolve.ciudad +' - '+resolve.pais);
			        	$('#razon_social').val(resolve.razon_social);
			        	$('#ruc').val(resolve.ruc);

		            	$('#nuevo_huesped_modal').modal('hide'); 
		            	$.tab('change tab', 'two');
		            }
		            $("#loader_producto").removeClass('active');
					$("#loader_producto").addClass('disabled');

		        }
		    });

		} else {
			$('#frmNuevoHuesped').form('validate form');
		}
  	});

    $('body').on('click', '#nuevo_dni', function(){
	 	$(this).attr("readonly", false);
	});





});

