$(function () {
	$.fn.form.settings.rules.docExiste = function(value) {
	  	return (verificaExiste('dni', value) > 0 ? false : true);
	};

	function verificaExiste(field, param) {
     	var count;
     	$.ajax({
     		async: false,
            url: APP_URL+'/huesped/existeCampoEditar',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            dataType: 'json',
            data: { campo: field, valor: param, id_huesped : $('#id_huesped').val() },
            success: function (data) {
                count = data;
            }
        });
        return count;
	};

    $('#frmEditar').form({
    	keyboardShortcuts: false,
    	fields: {
	      	nombre: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    dni: {
		        rules: [
		        	{ type : 'docExiste', prompt : 'El numero de documento ya fue registrado'},
		        	{ type : 'empty', prompt : 'Complete este campo'},
		        ]
		    },
		    telefono: {
		    	optional: true,
		        rules: [{ type : 'integer', prompt : 'Ingrese solo números'}]
		    },
		    email: {
		    	optional: true,
		        rules: [{ type : 'email', prompt : 'Ingrese un email válido'}]
		    },
		    razon_social: {
		    	depends: 'ruc',
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    ruc: {
		    	depends: 'razon_social',
		        rules: [
		        	{ type : 'integer', prompt : 'Ingrese solo numeros'},
		        	{ type : 'empty', prompt : 'Complete este campo'},
		        	{ type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
		        ]
		    },
		    ciudad: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    pais: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
    	},
    	inline : true,
    });

    $('.btn_guardar').on('click', function() {
		if ($('#frmEditar').form('is valid')) {
			$('#update_modal').modal({
  				closable: false,
		    	onApprove : function() {
		    		sendForm();
			    }
	  		}).modal('show'); 
		} else {
			$('#frmEditar').form('validate form');
		}
  	});

	function sendForm() {

	    var data = $('#frmEditar').serialize();

        $.requestApi('/huesped/actualizar', data, 'POST', function (resolve) {
	        if (resolve) {
	            $.showMessages(resolve);
	        }
	    });
        
        return false;
	};

});
