$(function () {

	$.fn.form.settings.rules.docExiste = function(value) {
	  	return (verificaExiste('dni', value) > 0 ? false : true);
	};

	function verificaExiste(field, param) {
     	var count;
     	$.ajax({
     		async: false,
            url: APP_URL+'/huesped/existeCampo',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            dataType: 'json',
            data: { campo: field, valor: param},
            success: function (data) {
                count = data;
            }
        });
        return count;
	};

    $('#frmNuevo').form({
    	keyboardShortcuts: false,
    	fields: {
	      	nombre: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    dni: {
		        rules: [
		        	{ type : 'docExiste', prompt : 'El numero de documento ya fue registrado'},
		        	{ type : 'empty', prompt : 'Complete este campo'},
		        ]
		    },
		    telefono: {
		    	optional: true,
		        rules: [{ type : 'integer', prompt : 'Ingrese solo números'}]
		    },
		    email: {
		    	optional: true,
		        rules: [{ type : 'email', prompt : 'Ingrese un email válido'}]
		    },
		    razon_social: {
		    	depends: 'ruc',
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    ruc: {
		    	optional: true,
		        rules: [
		        	{ type : 'integer', prompt : 'Ingrese solo numeros'},
		        	{ type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
		        ]
		    },
		    ciudad: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
    	},
    	inline : true,
    });

	$('.btn_registrar').on('click', function() {
		if ($('#frmNuevo').form('is valid')) {
			$('#register_modal').modal({
  				closable: false,
		    	onApprove : function() {
		    		sendForm();
			    }
	  		}).modal('show'); 
		} else {
			$('#frmNuevo').form('validate form');
		}
  	});

	function sendForm() {

	    var data = $('#frmNuevo').serialize()+'&pais='+$('#pais').dropdown('get text').toUpperCase(); 
        $.requestApi('/huesped/registrar', data, 'POST', function (resolve) {
	        if (resolve) {
	            if (resolve.message === "success") {
	                $.Helper.clearFields("#frmNuevo");
	            }
	            $.showMessages(resolve);
	        }
	    });
        
        return false;
	};

});
