/*================================================================================
Project Name: Seven - Sistema de Ventas
Version: 1.0
Author: Carlos Yasmany
================================================================================*/

var seven = {

    ready : function(){
        /**
         * Inicializamos Componentes
         */
        $('.ui.accordion').accordion();
        $('.ui.dropdown').dropdown();
        $('.ui.search.dropdown').dropdown({ fullTextSearch: true });
        $('.tabular.menu .item').tab();

        $('#sidebar').sidebar('attach events', '#launch_icon');
        $('.ui.checkbox').checkbox();

        $('.fecha').datepicker({
            dateFormat: 'yy-mm-dd', 
            changeMonth: true, 
            changeYear: true, 
            yearRange: '-100:+100'
        });

        $('.fecha_pas').datepicker({
            dateFormat: 'yy-mm-dd', 
            changeMonth: true, 
            changeYear: true, 
            yearRange: '-100:+0'
        });

        $('.fecha_fut').datepicker({
            dateFormat: 'yy-mm-dd', 
            changeMonth: true, 
            changeYear: true, 
            minDate: 1,
            yearRange: '-0:+100'
        });

        $(".fecha1").datepicker({
            changeMonth: true, 
            changeYear: true, 
            yearRange: '-100:+0',
            dateFormat: "yy-mm-dd",
            onSelect: function(selectedDate) {
                $(".fecha2").datepicker("option", "minDate", selectedDate);
            }
        });
            
        $(".fecha2").datepicker({
            changeMonth: true, 
            changeYear: true, 
            yearRange: '-100:+0',
            minDate: 0,
            dateFormat: "yy-mm-dd",
        });

        $('.fecha_hora').datetimepicker({
            dateFormat: 'yy-mm-dd', 
            changeMonth: true, 
            changeYear: true,
            yearRange: '-10:+10',
         });

        $('.fecha_fut_hora').datetimepicker({
            dateFormat: 'yy-mm-dd', 
            changeMonth: true, 
            changeYear: true,
            minDate: 0,
            yearRange: '-0:+100'
         });


        var f = new Date(); 
        $('.hasDate').val(f.getFullYear() +'-'+ ((f.getMonth()+1) > 9 ? f.getMonth()+1 : '0'+(f.getMonth()+1))+'-'+(f.getDate()));

        if($(window).innerWidth() <= 1024) {
            $('#sidebar').sidebar('hide');
            $('#launch_icon').css('display','block');
            $('#pusher').css('margin-right','0px');
        }
        else{
            $('#launch_icon').css('display','none');
            $('#pusher').css('margin-right','260px');
        }

        $(window).resize(function () {
            if ($(window).innerWidth() <= 1024 ) {
                $('#sidebar').sidebar('hide');
                $('#launch_icon').css('display','block');
                $('#pusher').css('margin-right','0px');
            }
            else{
                $('#sidebar').addClass('visible');
                $('#launch_icon').css('display','none');
                $('#pusher').css('margin-right','260px');
                if ($('#pusher').hasClass('dimmed')) {
                    $('#sidebar').sidebar('toggle');
                    setTimeout(function(){ $('#sidebar').addClass('visible'); }, 100);
                }
            }
        });

        /**
         * actualizando boleta factura de formulario de ventas
         */
        $('#select_comprobante_venta').dropdown({
            onChange: function(value, text, $selectedItem) {
                $('#frmNuevo').form('remove prompt', ['numero_documento']);
                $('#frmNuevo').form('remove prompt', ['nombre']);
                $("#tipo_comprobante").val(value);
                $("#tipo_documento").val(value);
 
                if (text == 'FACTURA') {
                    $("#nomb").text("Razon Social");
                    $("#tipo_doc").text("RUC");
                    $('input[name="numero_documento"]').attr('maxlength', 11);
                    $('#frmNuevo').form('add rule', 'numero_documento', {
                        rules: [
                            { type : 'integer', prompt : 'Ingrese solo números'},
                            { type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
                        ]
                    });
                    $('#frmNuevo').form('add rule', 'nombre', {
                        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
                    });
                }
                if (text == 'BOLETA') {
                    $("#nomb").text("Nombre del Cliente");
                    $("#tipo_doc").text("DNI");
                    $('input[name="numero_documento"]').attr('maxlength', 8);
                    $('#frmNuevo').form('add rule', 'numero_documento', {
                        depends : 'nombre',
                        rules: [
                            { type : 'integer', prompt : 'Ingrese solo números'},
                            { type : 'exactLength[8]', prompt : 'El DNI debe tener {ruleValue} digitos'}
                        ]
                    });
                    $('#frmNuevo').form('add rule', 'nombre', {
                        depends : 'numero_documento',
                        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
                    });
                }

                $.requestApi('/venta/getCorrelativo', {'id_local': __user.id_local, 'id_tipo_comprobante': value}, 'GET', function (resolve) {
                    if (resolve)
                        $('#serie_comprobante').text(resolve.serie);
                        $('#numero_comprobante').text(resolve.numero);
                });
            }
        });

         /**
         * actualizando boleta factura de formulario de CONTINGENCIAS
         */
        $('#select_comprobante_contingencia').dropdown({
            onChange: function(value, text, $selectedItem) {
                $('#frmNuevo').form('remove prompt', ['numero_documento']);
                $('#frmNuevo').form('remove prompt', ['nombre']);
                $("#tipo_comprobante").val(value);
                $("#tipo_documento").val(value);

                if (text == 'FACTURA') {
                    $("#nomb").text("Razon Social");
                    $("#tipo_doc").text("RUC");
                    $('input[name="numero_documento"]').attr('maxlength', 11);
                    $('#frmNuevo').form('add rule', 'numero_documento', {
                        rules: [
                            { type : 'integer', prompt : 'Ingrese solo números'},
                            { type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
                        ]
                    });
                    $('#frmNuevo').form('add rule', 'nombre', {
                        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
                    });
                }
                if (text == 'BOLETA') {
                    $("#nomb").text("Nombre del Cliente");
                    $("#tipo_doc").text("DNI");
                    $('input[name="numero_documento"]').attr('maxlength', 8);
                    $('#frmNuevo').form('add rule', 'numero_documento', {
                        depends : 'nombre',
                        rules: [
                            { type : 'integer', prompt : 'Ingrese solo números'},
                            { type : 'exactLength[8]', prompt : 'El DNI debe tener {ruleValue} digitos'}
                        ]
                    });
                    $('#frmNuevo').form('add rule', 'nombre', {
                        depends : 'numero_documento',
                        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
                    });
                }
                
            }
        });

        /**
         * cargar alerta reserva
         */ 
        $._requestApi('/reserva/alertas', {}, 'GET', function (resolve) {
            if (resolve){
                cargarAlerta(resolve);
            }
        })

        /**
         * Muestar modal de detalle del stock en alertas
         */ 
        $('body').on('click', '.alerta_reserva', function(){ 
            
            var id = $(this).data("id");
            location.href = APP_URL+"/reserva/detalles/"+id;

        });
   
    },
}


$(document).ready(seven.ready);

function cargarAlerta(data) {
    count = 0;
    if (data.length > 0) {
        data.forEach(function (elem) {
            var nombre = elem.nombre.toLowerCase();
            $("#item_alertas").append('<div class="item alerta_reserva" data-id="'+elem.id_reserva+'"><div class="ui violet label">Reservacion </div>'+nombre.charAt(0).toUpperCase() + nombre.substr(1)+'</div>');
            count = count + 1;
        });
    }    
    $('#numero_alertas').text(count); 
}