$(function () {

	/******************************************************************************/
	/* start: valida formulario de ventas
	/******************************************************************************/

    $('#frmNuevo').form({
    	keyboardShortcuts: false,
    	fields: {
		    numero_documento: {
		        rules: [
                    { type : 'integer', prompt : 'Ingrese solo números'},
                    { type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
                ]
		    },
		    nombre: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
    	},
    	inline : true,
	});

  	$('.btn_registrar').on('click', function() {
  		var count=$("#tbody tr:first > td").length;
    	if (count > 0 && ($('#total_venta') !== "")) {
    		if ($('#total_venta').val() !== "") {
			  	if ($('#frmNuevo').form('is valid')) {
					$('#register_modal').modal({
		  				closable: false,
				    	onApprove : function() {
				    		sendForm();
					    }
			  		}).modal('show');  
				} else {
					$('#frmNuevo').form('validate form');
				}
			} else {
				swal("Los precios", "de los conceptos no son validos", "warning");
			}
		} else {
			swal("Por favor", "agregue algun concepto a la lista", "warning");
		}
  	});	

  	function sendForm() {

	    var data = $('#frmNuevo').serialize();

        $.requestApi('/venta/registrar', data, 'POST', function (resolve) {
	        if (resolve) {
	            $.showMessagesImprimir(resolve, APP_URL+"/venta/detalles/"+resolve.id_venta, APP_URL+"/../pdf/imprimeTicket.php?id_venta="+resolve.id_venta);
	        }
	    });
  
        return false;
	};


	/******************************************************************************/
	/* start: muestra oculta fecha de pago al credito
	/******************************************************************************/
	$('[name="tipo_pago"]').change(function() {
		var option= $("option:selected", this).val();
		
	  	if (option == "CREDITO") {
			$('#fecha_pago').css('visibility', 'visible');
			$('#frmNuevo').form('add rule', 'fecha_pago', {
		        rules: [{ type : 'empty', prompt : 'Ingrese una fecha de pago'}]
		    });
		} else {
		    $('#fecha_pago').css('visibility', 'hidden');
			$('#frmNuevo').form('remove fields', ['fecha_pago']);
			$('#frmNuevo').form('remove prompt', ['fecha_pago']);
			$('[name="fecha_pago"]').val(''); 
		}
	});

	$('[name="fecha_pago"]').on('change', function(){
		if ($('[name="fecha_pago"]').val() !== '' ) {
			$('#frmNuevo').form('remove prompt', ['fecha_pago']);
		}
	}); 

	/*********************************************************************************************************/
	/* modal mostrar todos los clientes
	/*********************************************************************************************************/

	function buscarNombreCliente(cliente) {
  
        $._requestApi('/cliente/getByNombre', {'search' : cliente }, 'GET', function (resolve) {
	        if (resolve) {
	        	var datos = [];
                for( var i=0; i< resolve.length; i++ ){
                    resolve[i]['i'] = i+1;
                    if(resolve[i]){
                        datos.push(renderClientes(resolve[i]));
                    }
                }
                $('#tbody_clientes').html(datos.join(''));
	    	}
	    	$("#btn_buscar_cli").removeClass('loading');
	    });
  	};

	$('.btn_buscar_cliente').on('click', function() {
  		$('#buscar_cliente_modal').modal('show'); 
  		$('#buscar_cliente').val('');
  		//resetearTablaProducto();
  	});	


	$('#buscar_cliente').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	$("#btn_buscar_cli").addClass('loading');
	    	var cliente = $('#buscar_cliente').val();
    		buscarNombreCliente(cliente);
    	}	
	});

	$('#btn_buscar_cli').on('click', function() {
		$("#btn_buscar_cli").addClass('loading');
    	var cliente = $('#buscar_cliente').val();
    	buscarNombreCliente(cliente);
  	});


    $('body').on('click', '.btn_seleccionar_cliente', function(){ 
		$("#numero_documento").val($(this).data("documento"));
		$("#nombre_cliente").val($(this).data("nombre"));
		$("#direccion").val($(this).data("direccion"));
		$('#buscar_cliente_modal').modal('hide'); 
  	});


	/******************************************************************************/
	/* buscar cliente con Keypress
	/******************************************************************************/

	$('#numero_documento').on('keyup', function(){
  		$(this).val($(this).val().trim());
    });

  	$('#numero_documento').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	var num = $('#numero_documento').val();
    		buscarDocumentoCliente(num);
    	}	
	});

/*	$('#numero_documento').on('focusout', function(e){
	    var num = $('#numero_documento').val();
    	buscarDocumentoCliente(num);
	});*/

	$('#loading_doc').on('click', function() {
    	var num = $('#numero_documento').val();
    	buscarDocumentoCliente(num);
  	});

  	function buscarDocumentoCliente(num) 
  	{	
    	if ( $('#tipo_documento').val() == 1 && num.length == 11  ) // FACTURA
    	{
    		$("#loading_doc").addClass('loading');
    		$._requestApi('/cliente/getRucByApi', {'numero_documento' : num }, 'GET', function (resolve) {
        		if (resolve.nombre) {
		        	$('#nombre_cliente').val(resolve.nombre);
		        	resolve.direccion !== '-' ? $('#direccion').val(resolve.direccion) : $('#direccion').val('');
		        }
		        else {
		        	$('#nombre_cliente').val('');
		        	$('#direccion').val('');
		        }
		        $("#loading_doc").removeClass('loading');
        	}, function () {
        		$("#loading_doc").removeClass('loading');
        	});
    	}

    	if ( $('#tipo_documento').val() == 2  && num.length == 8 ) // BOLETA
    	{
    		$("#loading_doc").addClass('loading');
    		$._requestApi('/cliente/getDniByApi', {'numero_documento' : num }, 'GET', function (resolve) {
        		if (resolve.nombre) {
		        	$('#nombre_cliente').val(resolve.nombre.trim());
		        	resolve.nombre.trim() !== '' ? $('#direccion').val('-') : $('#direccion').val('');
		        }
		        else {
		        	$('#nombre_cliente').val('');
		        	$('#direccion').val('');
		        }
		        $("#loading_doc").removeClass('loading');
        	}, function () {
        		$("#loading_doc").removeClass('loading');
        	});

    	}
  	}	


	/******************************************************************************/
	/* start: agrega concepto a lista
	/******************************************************************************/


 	/*function agregarTabla() {
 		var filas = contarFilas();

 		agregarFila(asignaId(filas));
  	}*/
/*
  	function agregarFila(data) {

		var nuevoProducto=''+
            '<tr class="rows" id="'+data+'">'+
            	'<td><input type="text" name="cantidad[]" class="cant '+data+'" id="cant'+data+'" value="1" size="1"></td>'+
                '<td><input type="text" name="descripcion[]" id="conc'+data+'" value="" /></td>'+
                '<td class="warning"><input type="text" class="prec '+data+'" name="precio_venta[]" id="prec'+data+'" value="" size="2"/></td>'+
                '<td style="display:none"><input type="hidden" name="descuento[]" class="desc '+data+'" id="desc'+data+'" value="0.00" size="1"></td>'+
                '<td style="display:none"><input type="hidden" name="impuesto[]" class="impu '+data+'" id="impu'+data+'" value="0.00"/></td>'+
                '<td class="positive"><input type="hidden" name="subtotal[]" id="subt'+data+'" value="0.00"/><span id="v_subt'+data+'"></span></td>'+
                '<td><div class="ui mini vertical animated red button" onclick="quitarTabla(this)" title="Quitar de la lista"><div class="hidden content">Quitar</div><div class="visible content"><i class="times icon"></i></div></div></td>'+
            '</tr>';
          
        $("#tbody").append(nuevoProducto);

        calcularTotal(); 
  	}*/


	/*********************************************************************************************************/
	/* start: calcula precios al presionar tecla
	/*********************************************************************************************************/
	$('body').on('click', '.prec', function(){
	 	$(this).attr("readonly", false);
	});

  	$('body').on('keyup', '.cant', function(){

  		$(this).val($(this).val().trim());
    	var arr = $(this).attr('class').split(" ");
    	var imp = $('#impu'+arr[1]).attr('class').split(" ");
        calculaSubtotal(arr[1], imp[1]);
        calcularTotal(); 
	    
    });

    $('body').on('keyup', '.desc', function(){

    	$(this).val($(this).val().trim());
		var arr = $(this).attr('class').split(" ");
    	var imp = $('#impu'+arr[1]).attr('class').split(" ");
        calculaSubtotal(arr[1], imp[1]);
        calcularTotal(); 
    	
    });

    $('body').on('keyup', '.prec', function(){

    	$(this).val($(this).val().trim());
		var arr = $(this).attr('class').split(" ");
    	var imp = $('#impu'+arr[1]).attr('class').split(" ");
        calculaSubtotal(arr[1], imp[1]);
        calcularTotal(); 
    	
    });

    /*********************************************************************************************************/
	/* modal agregar concepto
	/*********************************************************************************************************/  	
	$('.btn_nuevo_concepto').on('click', function() {
  		agregarTabla();
  	});	
});

/*********************************************************************************************************/
/* funciones de calculo
/*********************************************************************************************************/

function agregarTabla() {
	var filas = contarFilas();

	agregarFila(asignaId(filas));
}


function agregarFila(data) {

	var nuevoProducto=''+
	    '<tr class="rows" id="'+data+'">'+
	    	'<td><input type="text" name="cantidad[]" class="cant '+data+'" id="cant'+data+'" value="1" size="1"></td>'+
	        '<td><input type="text" name="descripcion[]" id="conc'+data+'" value="" /></td>'+
	        '<td class="warning"><input type="text" class="prec '+data+'" name="precio_venta[]" id="prec'+data+'" value="" size="2"/></td>'+
	        '<td style="display:none"><input type="hidden" name="descuento[]" class="desc '+data+'" id="desc'+data+'" value="0.00" size="1"></td>'+
	        '<td style="display:none"><input type="hidden" name="impuesto[]" class="impu '+data+'" id="impu'+data+'" value="0.00"/></td>'+
	        '<td class="positive"><input type="hidden" name="subtotal[]" id="subt'+data+'" value="0.00"/><span id="v_subt'+data+'"></span></td>'+
	        '<td><div class="ui mini vertical animated red button" onclick="quitarTabla(this)" title="Quitar de la lista"><div class="hidden content">Quitar</div><div class="visible content"><i class="times icon"></i></div></div></td>'+
	    '</tr>';
	  
	$("#tbody").append(nuevoProducto);

	calcularTotal(); 
}


  	


function calculaSubtotal(id, imp) { 
	var subt = (parseFloat($('#prec'+id).val()).toFixed(2)*parseFloat($('#cant'+id).val()).toFixed(2)) - parseFloat($('#desc'+id).val()).toFixed(2);
	$('#subt'+id).val(validaNumero($('#prec'+id).val()) && validaNumero($('#cant'+id).val()) && validaNumero($('#desc'+id).val()) && (subt > 0) ? subt.toFixed(2) : '');
    $('#v_subt'+id).text(validaNumero($('#prec'+id).val()) && validaNumero($('#cant'+id).val()) && validaNumero($('#desc'+id).val()) && (subt > 0) ? subt.toFixed(2) : '');
    calculaImpuesto(id, imp);
}

function calculaImpuesto(id, v_impu) {
	var impu = parseFloat($('#subt'+id).val()).toFixed(2) - parseFloat($('#subt'+id).val()).toFixed(2)/(1+(valor_impuesto/100));
	$('#impu'+id).val(validaNumero($('#subt'+id).val()) && !isNaN(impu) ? impu.toFixed(2) : '');
}

function validaNumero(valor) {
    var expresion=/^[0-9]+([\.]{1}[0-9]+)?$/;
    return !expresion.test(valor) ? false : true; 
}

function verificaExite(id) {
	exist = false;
	$('#tbody tr').each(function() {
    	if (this.id == id) {
    		exist = true;
    	}
  	});

	return exist;
}

function contarFilas() {
	count = 0;
	$('#tbody tr').each(function() {
    	count++;
  	});

	return count;
}

function asignaId(filas) {
	
	for (var i = 1; i <= filas; i++) {
		if (!verificaExite(i)) {
			break;
		}
	}
	return i;
}

function calcularTotal() {
	var total = 0;
	$('#tbody').find('tr').each(function(index, element) {
	    $(element).find('td').each(function(index1, element1) {
	        if(index1==5) { //Index empieza en 1
	            temp = parseFloat($(element1).text());
	            total+= temp;
	        }
	    });
	});
	$('#total_venta').val(!isNaN(total) ? total.toFixed(2) : '');
}

function quitarTabla(elem) {
    var elementoEliminar=$(elem).parent().parent();
    $(elementoEliminar).remove();
    calcularTotal();
}


function renderClientes(resolve){
	var arr = [];
    arr = [
        '<tr data-table="'+resolve.id_cliente+'">',
            '<td>',resolve.i,'</td>',
            '<td>',resolve.nombre,'</td>',
            '<td>',resolve.tipo_documento.nombre,'</td>',
            '<td>',resolve.numero_documento,'</td>',
            '<td><div class="ui mini vertical animated positive button btn_seleccionar_cliente" title="Seleccionar este cliente" data-nombre="',resolve.nombre,'" data-documento="',resolve.numero_documento,'" data-direccion="',resolve.direccion,'"><div class="hidden content">Elegir</div><div class="visible content"><i class="check icon"></i></div></div></td>',
        '</tr>',
    ];
    return arr.join(''); 
}