$(function () {

	/******************************************************************************/
	/* start: valida formulario
	/******************************************************************************/

    $('#frmNuevo').form({
    	keyboardShortcuts: false,
    	fields: {
		    id_habitacion: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una habitacion'}]
		    },
            nombre: {
                rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            },
            dni: {
                rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            },
            telefono: {
                optional: true,
                rules: [{ type : 'integer', prompt : 'Ingrese solo números'}]
            },
            email: {
                optional: true,
                rules: [{ type : 'email', prompt : 'Ingrese un email válido'}]
            },
            razon_social: {
                depends: 'ruc',
                rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            },
            ruc: {
                depends: 'razon_social',
                rules: [
                    { type : 'integer', prompt : 'Ingrese solo numeros'},
                    { type : 'empty', prompt : 'Complete este campo'},
                    { type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
                ]
            },
            ciudad: {
                rules: [{ type : 'empty', prompt : 'Complete este campo'}]
            },
    	},
    	inline : true,
	});

  	$('.btn_registrar').on('click', function() {
	  	if ($('#frmNuevo').form('is valid')) {
			$('#register_modal').modal({
  				closable: false,
		    	onApprove : function() {
		    		sendForm();
			    }
	  		}).modal('show');  
		} else {
			$('#frmNuevo').form('validate form');
		}

  	});	

  	function sendForm() {

	    var data = $('#frmNuevo').serialize()+'&pais='+$('#pais').dropdown('get text').toUpperCase()+'&motivo='+$('input[name="motivo"]:checked').next('label').text().toUpperCase(); 
        $.requestApi('/hospedar/registrar_reserva', data, 'POST', function (resolve) {
	        if (resolve) {
	            $.showMessages(resolve, true, APP_URL+"/hospedar/detalles/"+resolve.id_hospedar);
	        }
	    });
  
        return false;
	};


	/*********************************************************************************************************/
	/* Buscar Habitaciones Disponibles
	/*********************************************************************************************************/
	$('.btn_buscar_habitacion').on('click', function() {
		$('#buscar_habitacion_disponibles').val('');
  		$('#buscar_habitacion_modal').modal('show'); 
  		resetearTabla("#tabla_disponibles");
  	});	

  	$('#buscar_habitacion_disponibles').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	var numero = $('#buscar_habitacion_disponibles').val();
    		buscarTabla(numero, "#tabla_disponibles");
    	}	
	});

	$('#btn_buscar_habitacion_disponibles').on('click', function() {
    	var numero = $('#buscar_habitacion_disponibles').val();
    	buscarTabla(numero, "#tabla_disponibles");
  	});

	$('body').on('click', '.btn_seleccionar_habitacion', function(){ 
    	var id = $(this).data("id");
		$("select[name='id_habitacion']").dropdown('set selected', id);
        $('#buscar_habitacion_modal').modal('hide'); 
  	});

});

/*********************************************************************************************************/
/* funciones de busqueda
/*********************************************************************************************************/

function buscarTabla(value, id_tabla){
 	var rows = document.querySelectorAll(id_tabla + ' tbody tr');
    for(var i = 0; i < rows.length; i++){
        var showRow = false;
        var row = rows[i];
        row.style.display = 'none';
        for(var x = 0; x < row.childElementCount; x++){
            if(row.children[x].textContent.toLowerCase().indexOf(value.toLowerCase()) > -1){
                showRow = true;
                break;
            }
        }
        if(showRow){
            row.style.display = null;
        }
    }
}

function resetearTabla(id_tabla){
	value = '';
	var rows = document.querySelectorAll(id_tabla + ' tbody tr');
    for(var i = 0; i < rows.length; i++){
        var showRow = false;
        var row = rows[i];
        row.style.display = 'none';
        for(var x = 0; x < row.childElementCount; x++){
            if(row.children[x].textContent.toLowerCase().indexOf(value.toLowerCase().trim()) > -1){
                showRow = true;
                break;
            }
        }
        if(showRow){
            row.style.display = null;
        }
    }
}