@extends('layout.main')
@section('content')
    
    @if ($data)
        <div class="sixteen wide tablet fifteen wide computer column ">
            <div class="ui segment">
                
                <h4 class="ui dividing header teal centered">EDITAR DATOS DE LA HABITACION</h4>
                <br>

                <form class="ui form" id="frmEditar" autocomplete="off">
                    <input type="hidden" id="id_habitacion" name="id_habitacion" value="{{ $data->id_habitacion}}">

                    <div class="three fields">
                        <div class="five wide field">
                            <div class="ui fluid large white label">Numero de Habitacion</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui small input">
                                <input type="text" name="numero" maxlength="5" value="{{ $data->numero}}">
                            </div> 
                        </div>
                    </div>

                    <div class="three fields">
                        <div class="five wide field">
                            <div class="ui fluid large white label">Precio de la habitacion</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui labeled small input">
                                <label class="ui label">S/</label>
                                <input type="text" name="precio" maxlength="7" value="{{ $data->precio}}">
                            </div> 
                        </div>
                    </div>

                    <div class="three fields">
                       <div class="five wide field">
                            <div class="ui fluid large white label">Tipo de Habitacion</div>
                        </div>
                        <div class="field">
                            <select class="ui fluid small input dropdown" name="id_tipo_habitacion">
                                <option value="">Seleccione</option>
                                
                                @foreach($tipo_habitacion as $tipo)
                                    <option value=""> Seleccione</option>
                                    @if($tipo->id_tipo_habitacion== $data->id_tipo_habitacion)
                                        <option value="{{ $tipo->id_tipo_habitacion }}" selected>{{ $tipo->nombre }}</option>
                                    @else
                                        <option value="{{ $tipo->id_tipo_habitacion }}">{{ $tipo->nombre }}</option>
                                    @endif
                                @endforeach


                            </select> 
                        </div>
                    </div>

                    <div class="three fields">
                        <div class="five wide field">
                            <div class="ui fluid large white label">Descripcion de la habitacion</div>
                        </div>
                        <div class="ten wide field">
                            <div class="ui small input ">
                              <input type="text" name="descripcion" maxlength="100" oninput="$.upperCase(this)" value="{{ $data->descripcion}}">
                            </div>
                        </div>
                    </div>

                        
                    <div class="form_footer">
                        <a class="ui left floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>
                        <div class="ui right floated primary button btn_guardar"><i class="save icon"></i>GUARDAR</div>
                    </div>    
                </form>

            </div>
        </div>
        <!--start update modal -->
        <div class="ui small basic modal" id="update_modal">
            <div class="ui icon header"><i class="paper plane icon"></i>Guardar cambios</div>
            <div class="content" style="text-align: center; font-size: 16px">
              <p>¿Está seguro que quiere guardar los cambios que hizo?</p>
            </div>
            <div class="actions">
                <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
                <div class="ui green ok inverted button" title="Haga clic para guardar cambios"> <i class="checkmark icon"></i>Guardar</div>
            </div>
        </div>
        <!--end update modal -->
    @else
        <div class="sixteen wide tablet fifteen wide computer column ">
            <div class="ui segment">
                <h3 class="ui header black centered">No se encuentra el registro que desea editar</h3>
            </div>
        </div>    
    @endif

@stop

@section('scripts')
    <script src="{{ asset('js/habitacion/editar.js') }}"></script>
@stop


