@extends('layout.main')
@section('content')
@if ($data)
    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE HABITACION <div class="ui violet label">{{$data->habitacion->numero}}</div></h4>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que registró ingreso :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->usuario->nombres)) }} {{ ucwords(mb_strtolower($data->usuario->apellidos)) }} ({{ $data->usuario->username }})</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Habitacion Ocupada :</div>
                        <div class="sixteen wide mobile nine wide tablet  four wide computer column">{{ $data->habitacion->numero }} - {{ $data->habitacion->tipo_habitacion->nombre }}</div>
                        <div class="sixteen wide mobile seven wide tablet  four wide computer column message_header">Precio de habitacion por Noche :</div>
                        <div class="sixteen wide mobile nine wide tablet  three wide computer column">S/ {{ $data->habitacion->precio }}</div>
                    </div>
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Facturado :</div>
                        @if ($data->id_venta == null)
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">NO</div>
                        @else
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><a href="{{ url('venta/detalles/'.$data->id_venta) }}">Ver detalles de la factura</a></div>
                        @endif
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Monto a Cobrar :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><span id="monto_acumulado" style="color: red !important"></span></div>
                    </div>

                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Ingreso :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ date('d-m-Y g:i A', strtotime($data->fecha_ingreso))  }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Monto de Adelanto :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ {{ $data->adelanto != null ? $data->adelanto  : '0.00' }}</div>
                    </div>

                    <div class="row" style="padding-bottom: 0px !important">

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Tiempo Transcurrido :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><span id="tiempo_transcurrido"></span></div>
                    </div>
               
                </div>
            </div>


            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Nombre del Huesped</th>
                        <th class="center aligned">DNI</th>
                        <th class="center aligned">Procedencia</th>
                        <th class="center aligned">N° Papeleta</th>
                        <th class="center aligned">Acciones</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    @foreach ($detalles as $detalle)
                    <tr data-table="{{ $detalle->id_detalle_hospedar }}">
                        <td><a href="{{ url('huesped/editar/'.$detalle->id_huesped) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($detalle->huesped->nombre)) }} </a>
                            <input type="hidden" name="id_huesped[]" value="{{ $detalle->id_huesped }}">
                        </td>
                        <td>{{ $detalle->huesped->dni }}</td>
                        <td>{{ $detalle->huesped->ciudad }} - {{ $detalle->huesped->pais }}</td>
                        <td>{{ $detalle->papeleta }}</td>
                        <td>
                            <div class="ui mini vertical animated positive button button_info_modal" title="Ver informacion detallada" data-id="{{ $detalle->id_huesped }}">
                                <div class="hidden content">Info</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>

                <div class="ui small right floated red button btn_desocupar" data-id="{{ $data->id_hospedar }}"><i class="times icon"></i>Desocupar</div>
                <a class="ui small right floated blue button" href="{{ url('hospedar/transferir/'.$data->id_hospedar) }}"><i class="random icon"></i>Transferir</a>
                <a class="ui small right floated yellow button" href="{{ url('hospedar/agregar/'.$data->id_hospedar) }}"><i class="user plus icon"></i>Agregar Huesped</a>

                @if ($data->id_venta == null)
                <a class="ui small right floated green button btn_facturar" href="{{ url('venta/hospedar_venta/'.$data->id_hospedar) }}"><i class="dollar sign icon"></i>Facturar</a>
                @else
                    <a class="ui small right floated green button btn_facturar" href="{{ url('venta/detalles/'.$data->id_venta) }}"><i class="dollar sign icon"></i>Detalles de Factura</a>
                @endif
            </div>  

        </div>
    </div>

    <!--start delete modal -->
    <div class="ui small basic modal" id="delete_modal">
        <div class="ui icon header"><i class="times circle icon"></i>Desocupar Habitacion</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere desocupar esta habitacion?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para desocupar"> <i class="checkmark icon"></i>Desocupar</div>
        </div>
    </div>
    <!--end delete modal -->

    <!--start details modal -->
    <div class="ui standard small modal" id="detalles_modal">
        <div class="header">Información del Huesped</div>
        <div class="image content">
            <div class="ui large circular image">
                <img id="url_avatar" src="">
            </div>
            <div class="description">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Nombre : </b></div>
                        <div class="eleven wide column"><span id="_1"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>N° Doc. Identidad : </b></div>
                        <div class="eleven wide column"><span id="_2"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Genero : </b></div>
                        <div class="eleven wide column"><span id="_3"></span></div>
                    </div>
                   <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>F. Nacimiento : </b></div>
                        <div class="eleven wide column"><span id="_4"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Telefono : </b></div>
                        <div class="eleven wide column"><span id="_5"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Email : </b></div>
                        <div class="eleven wide column"><span id="_6"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Ocupacion : </b></div>
                        <div class="eleven wide column"><span id="_7"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Pais : </b></div>
                        <div class="eleven wide column"><span id="_8"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Ciudad : </b></div>
                        <div class="eleven wide column"><span id="_9"></span></div>
                    </div>
                    
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="sixteen wide column"><h4 class="ui dividing header teal centered">Datos de la empresa que representa</h4></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Razon Social : </b></div>
                        <div class="eleven wide column"><span id="_10"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Ruc : </b></div>
                        <div class="eleven wide column"><span id="_11"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Direccion : </b></div>
                        <div class="eleven wide column"><span id="_12"></span></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="actions">
            <div class="ui primary right labeled icon deny button">Cerrar<i class="times icon"></i></div>
        </div>
    </div>
    <!--end details modal -->

 @else
    <div class="sixteen wide tablet fifteen wide computer column ">
        <div class="ui segment">
            <h3 class="ui header black centered">No se puede realizar esta accion</h3>
        </div>
    </div>    
@endif
@stop

@section('scripts')
    
    <script src="{{ asset('js/hospedar/detalles.js') }}"></script>
    <script type="text/javascript">

        $(function () {
            var fecha_ingreso = '{!!$data->fecha_ingreso!!}';
            $('#tiempo_transcurrido').html(tiempo_transcurrido(fecha_ingreso)); 
            //$('#fecha_ingreso').html(fecha_ingreso_format(fecha_ingreso)); 

            var precio = '{!!$data->habitacion->precio!!}';
            var fecha_actual = '{!!$fecha_actual!!}';

            resta = restaFechas(fecha_ingreso, fecha_actual);

            if (resta.dif_dias > 0){
                $('#monto_acumulado').html('S/ '+ (parseFloat(precio*resta.dif_dias)).toFixed(2)); 
            }
            else {
                $('#monto_acumulado').html('S/ '+ parseFloat(precio).toFixed(2)); 
            }

        })

    </script>
@stop

