@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            

            <div class="ui top attached tabular menu">
                <a class="green item active" data-tab="uno">Habitaciones Disponibles <div class="ui circular green label">{{$disponibles->count()}}</div></a>
            </div>
            
            <!-- start tab 1 -->
            <div class="ui bottom attached tab active" data-tab="uno">
                <br><br>
                <div class="ui equal width grid">
                    <div class="row">
                         <div class="column">
                            <div class="ui action small input"  autocomplete="off">
                                <input type="text" id="buscar_habitacion_disponibles" placeholder="Numero de habitacion">
                                <div class="ui icon button" id="btn_buscar_habitacion_disponibles" title="Clic para buscar"><i class="search icon"></i></div>
                            </div> 
                        </div>
                        <div class="column export_files" style="text-align: right">
                            <select class="ui small input dropdown" id="tipo_habitacion_disponibles">
                                <option value="">Seleccione</option>
                                <option value="TODOS">Todos</option>
                                @foreach ($tipo_habitacion as $tipo)
                                    <option value="{{ $tipo->nombre}}"> {{ ucwords(mb_strtolower($tipo->nombre)) }} </option>
                                @endforeach
                            </select>  
                        </div>
                    </div>
                </div>
                <table class="ui celled striped table" id="tabla_disponibles">
                    <thead>
                        <tr>
                            <th class="head_table">Numero</th>
                            <th class="head_table">Tipo</th>
                            <th class="head_table">Precio S/</th>
                            <th class="head_table">Estado</th>
                            <th class="head_table">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($disponibles as $habitacion)
                        <tr data-table="{{ $habitacion->id_habitacion }}">
                            <td><div class="ui violet label">{{ $habitacion->numero }}</div></td>
                            <td>{{ $habitacion->tipo_habitacion->nombre }}</td>
                            <td>{{ $habitacion->precio }}</td>
                            <td>
                                <div class="ui green label">{{ $habitacion->situacion }}</div>
                            </td>
                            <td>                         
                                <a class="ui mini vertical blue button" title="Registrar huesped en habitacion" href="{{ url('hospedar/nuevo/'.$habitacion->id_habitacion) }}">
                                    <div class="visible content"><i class="user plus icon"></i> Registrar huesped</div>
                                </a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table> 
            </div>
            <!-- end tab 1 -->

        </div>
    </div>

@stop


@section('scripts')
    <script src="{{ asset('js/hospedar/listar.js') }}"></script>
@stop

