@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            

            <div class="ui top attached tabular menu">
                <a class="yellow item active" data-tab="tres">Habitaciones en Mantenimento <div class="ui circular yellow label">{{$mantenimiento->count()}}</div></a>
                <a class="green item" data-tab="uno">Habitaciones Disponibles <div class="ui circular green label">{{$disponibles->count()}}</div></a>
                {{-- <a class="red item" data-tab="dos">Habitaciones Ocupadas <div class="ui circular red label">{{$ocupadas->count()}}</div></a> --}}
            </div>

            <!-- start tab 1 -->
            <div class="ui bottom attached tab active" data-tab="tres">
                <br><br>
                <div class="ui equal width grid">
                    <div class="row">
                         <div class="column">
                            <div class="ui action small input"  autocomplete="off">
                                <input type="text" id="buscar_habitacion_mantenimiento" placeholder="Numero de habitacion">
                                <div class="ui icon button" id="btn_buscar_habitacion_mantenimiento" title="Clic para buscar"><i class="search icon"></i></div>
                            </div> 
                        </div>
                        <div class="column export_files" style="text-align: right">
                            <select class="ui small input dropdown" id="tipo_habitacion_mantenimiento">
                                <option value="">Seleccione</option>
                                <option value="TODOS">Todos</option>
                                @foreach ($tipo_habitacion as $tipo)
                                    <option value="{{ $tipo->nombre}}"> {{ ucwords(mb_strtolower($tipo->nombre)) }} </option>
                                @endforeach
                            </select>  
                        </div>
                    </div>
                </div>
                <table class="ui celled striped table" id="tabla_mantenimiento">
                    <thead>
                        <tr>
                            <th class="head_table">Numero</th>
                            <th class="head_table">Tipo</th>
                            <th class="head_table">Precio S/</th>
                            <th class="head_table">Estado</th>
                            <th class="head_table">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($mantenimiento as $habitacion)
                        <tr data-table="{{ $habitacion->id_habitacion }}">
                            <td><div class="ui violet label">{{ $habitacion->numero }}</div></td>
                            <td>{{ $habitacion->tipo_habitacion->nombre }}</td>
                            <td>{{ $habitacion->precio }}</td>
                            <td>
                                <div class="ui yellow label">{{ $habitacion->situacion }}</div>
                            </td>
                            <td>                         
                                <div class="ui mini vertical green button button_activar_modal" title="Poner en disponible" data-id="{{ $habitacion->id_habitacion }}">
                                    <div class="visible content"><i class="check icon"></i> Habilitar habitacion</div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table> 
            </div>
            <!-- end tab 1 -->

            
            <!-- start tab 2 -->
            <div class="ui bottom attached tab" data-tab="uno">
                <br><br>
                <div class="ui equal width grid">
                    <div class="row">
                         <div class="column">
                            <div class="ui action small input"  autocomplete="off">
                                <input type="text" id="buscar_habitacion_disponibles" placeholder="Numero de habitacion">
                                <div class="ui icon button" id="btn_buscar_habitacion_disponibles" title="Clic para buscar"><i class="search icon"></i></div>
                            </div> 
                        </div>
                        <div class="column export_files" style="text-align: right">
                            <select class="ui small input dropdown" id="tipo_habitacion_disponibles">
                                <option value="">Seleccione</option>
                                <option value="TODOS">Todos</option>
                                @foreach ($tipo_habitacion as $tipo)
                                    <option value="{{ $tipo->nombre}}"> {{ ucwords(mb_strtolower($tipo->nombre)) }} </option>
                                @endforeach
                            </select>  
                        </div>
                    </div>
                </div>
                <table class="ui celled striped table" id="tabla_disponibles">
                    <thead>
                        <tr>
                            <th class="head_table">Numero</th>
                            <th class="head_table">Tipo</th>
                            <th class="head_table">Precio S/</th>
                            <th class="head_table">Estado</th>
                            <th class="head_table">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($disponibles as $habitacion)
                        <tr data-table="{{ $habitacion->id_habitacion }}">
                            <td><div class="ui violet label">{{ $habitacion->numero }}</div></td>
                            <td>{{ $habitacion->tipo_habitacion->nombre }}</td>
                            <td>{{ $habitacion->precio }}</td>
                            <td>
                                <div class="ui green label">{{ $habitacion->situacion }}</div>
                            </td>
                            <td>                         
                                <div class="ui mini vertical orange button button_mantener_modal" title="Poner en mantenimiento"  data-id="{{ $habitacion->id_habitacion }}">
                                    <div class="visible content"><i class="trash icon"></i> Poner en mantenimiento</div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table> 
            </div>
            <!-- end tab 2 -->

            <!-- start tab 3 -->
            <div class="ui bottom attached tab" data-tab="dos">
                <br><br>
                <div class="ui equal width grid">
                    <div class="row">
                         <div class="column">
                            <div class="ui action small input"  autocomplete="off">
                                <input type="text" id="buscar_habitacion_ocupadas" placeholder="Numero de habitacion">
                                <div class="ui icon button" id="btn_buscar_habitacion_ocupadas" title="Clic para buscar"><i class="search icon"></i></div>
                            </div> 
                        </div>
                        <div class="column export_files" style="text-align: right">
                            <select class="ui small input dropdown" id="tipo_habitacion_ocupadas">
                                <option value="">Seleccione</option>
                                <option value="TODOS">Todos</option>
                                @foreach ($tipo_habitacion as $tipo)
                                    <option value="{{ $tipo->nombre}}"> {{ ucwords(mb_strtolower($tipo->nombre)) }} </option>
                                @endforeach
                            </select>  
                        </div>
                    </div>
                </div>
                <table class="ui celled striped table" id="tabla_ocupadas">
                    <thead>
                        <tr>
                            <th class="head_table">Numero</th>
                            <th class="head_table">Tipo</th>
                            <th class="head_table">Precio S/</th>
                            <th class="head_table">Estado</th>
                            <th class="head_table">Acciones</th> 
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($ocupadas as $habitacion)
                        <tr data-table="{{ $habitacion->id_habitacion }}">
                            <td><div class="ui violet label">{{ $habitacion->numero }}</div></td>
                            <td>{{ $habitacion->tipo_habitacion->nombre }}</td>
                            <td>{{ $habitacion->precio }}</td>
                            <td>
                                <div class="ui red label">{{ $habitacion->situacion }}</div>
                            </td>
                            <td>                         
                                <div class="ui mini vertical orange button button_mantener_modal" title="Poner en mantenimiento"  data-id="{{ $habitacion->id_habitacion }}">
                                    <div class="visible content"><i class="trash icon"></i> Poner en mantenimiento</div>
                                </div>
                            </td> 
                        </tr>
                        @endforeach
                    </tbody>
                </table> 
            </div>
            <!-- end tab 3 -->




        </div>
    </div>

    <!--start delete modal -->
    <div class="ui small basic modal" id="mantenimiento_modal">
        <div class="ui icon header"><i class="trash alternate icon"></i>Poner en Mantenimiento</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere quiere poner en mantenimiento esta habitacion?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para poner en mantenimiento"> <i class="checkmark icon"></i>Proceder</div>
        </div>
    </div>
    <!--end delete modal -->

    <!--start delete modal -->
    <div class="ui small basic modal" id="activar_modal">
        <div class="ui icon header"><i class="check icon"></i>Habilitar Habitacion</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere habilitar esta habitacion?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para habilitar"> <i class="checkmark icon"></i>Habilitar</div>
        </div>
    </div>
    <!--end delete modal -->

@stop


@section('scripts')
    <script src="{{ asset('js/hospedar/listar.js') }}"></script>
@stop

