@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            

            <div class="ui top attached tabular menu">
                <a class="red item active" data-tab="dos">Habitaciones Ocupadas <div class="ui circular red label">{{$ocupadas->count()}}</div></a>
            </div>
            

            <!-- start tab 2 -->
            <div class="ui bottom attached tab active" data-tab="dos">
                <br><br>
                <div class="ui equal width grid">
                    <div class="row">
                         <div class="column">
                            <div class="ui action small input"  autocomplete="off">
                                <input type="text" id="buscar_habitacion_ocupadas" placeholder="Numero de habitacion">
                                <div class="ui icon button" id="btn_buscar_habitacion_ocupadas" title="Clic para buscar"><i class="search icon"></i></div>
                            </div> 
                        </div>
                        <div class="column export_files" style="text-align: right">
                            <select class="ui small input dropdown" id="tipo_habitacion_ocupadas">
                                <option value="">Seleccione</option>
                                <option value="TODOS">Todos</option>
                                @foreach ($tipo_habitacion as $tipo)
                                    <option value="{{ $tipo->nombre}}"> {{ ucwords(mb_strtolower($tipo->nombre)) }} </option>
                                @endforeach
                            </select>  
                        </div>
                    </div>
                </div>
                <table class="ui celled striped table" id="tabla_ocupadas">
                    <thead>
                        <tr>
                            <th class="head_table">Numero</th>
                            <th class="head_table">Tipo</th>
                            <th class="head_table">Fecha de Ingreso</th>
                            <th class="head_table">Estado</th>
                            <th class="head_table">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($ocupadas as $data)
                        <tr data-table="{{ $data->id_hospedar}}">
                            <td><div class="ui violet label">{{ $data->habitacion->numero }}</div></td>
                            <td>{{ $data->habitacion->tipo_habitacion->nombre }}</td>
                            <td>{{ date('d-m-Y g:i A', strtotime($data->fecha_ingreso))  }}</td>
                            <td>
                                <div class="ui red label">{{ $data->habitacion->situacion }}</div>
                            </td>
                            <td>                         
                                <a class="ui mini vertical blue button" title="Ver informacion detallada" href="{{ url('hospedar/detalles/'.$data->id_hospedar) }}">
                                    <div class="visible content"><i class="search icon"></i> Ver Detalles</div>
                                </a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table> 
            </div>
            <!-- end tab 2 -->

        </div>
    </div>

@stop


@section('scripts')
    <script src="{{ asset('js/hospedar/listar.js') }}"></script>
@stop

