@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">TRANSFERIR HUESPEDES DE LA HABITACION <div class="ui violet label">{{$data->habitacion->numero}}</div></h4>
            
            <form class="ui form" id="frmNuevo" autocomplete="off"> 

                <input type="hidden" name="id_hospedar_origen" value="{{$data->id_hospedar}}">
            
                <br><br>
                <div class="four fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Seleccione la Nueva Habitacion</div>
                    </div>
                    <div class="six wide field">
                        <select class="ui small search selection dropdown" name="id_habitacion">
                            <option value="">Seleccione...</option>
                            @foreach($disponibles as $data)
                               <option value="{{ $data->id_habitacion}}">{{ $data->numero }} - {{ $data->tipo_habitacion->nombre }}</option>
                            @endforeach 
                        </select> 
                    </div>
                    
                    <div class="three wide field">
                        <div class="ui fluid small green button btn_buscar_habitacion" title="Clic para ver lista de habitaciones"><i class="search icon"></i>Buscar Habitacion</div>
                    </div>
                </div>

                <br><br>

                <div class="form_footer">
                        <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>ATRAS</a>
                        <div class="ui right floated blue button btn_registrar"><i class="random icon"></i>TRANSFERIR</div>
                </div>

            </form>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="random icon"></i>Transferir Habitacion</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea transferir a los huespedes a esta nueva habitacion?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para transferir"> <i class="checkmark icon"></i>Transferir</div>
        </div>
    </div>
    <!--end register modal -->

    <!--start buscar producto modal -->
    <div class="ui standard large modal" id="buscar_habitacion_modal">
        <div class="header">Buscar Habitacion</div>
        <div class="scrolling content">
            <div class="ui disabled inverted dimmer" id="loader_busqueda">
                <div class="ui text loader">Procesando...</div>
            </div>

            <div class="ui action small input"  autocomplete="off">
                <input type="text" id="buscar_habitacion_disponibles" placeholder="Numero de habitacion">
                <div class="ui icon button" id="btn_buscar_habitacion_disponibles" title="Clic para buscar"><i class="search icon"></i></div>
            </div>


            <table class="ui celled striped table" id="tabla_disponibles">
                <thead>
                    <tr>
                        <th class="head_table">Numero</th>
                        <th class="head_table">Tipo</th>
                        <th class="head_table">Precio S/</th>
                        <th class="head_table">Estado</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody id="tbody_productos">
                    @foreach ($disponibles as $habitacion)
                    <tr data-table="{{ $habitacion->id_habitacion }}">
                            <td><div class="ui violet label">{{ $habitacion->numero }}</div></td>
                            <td>{{ $habitacion->tipo_habitacion->nombre }}</td>
                            <td>{{ $habitacion->precio }}</td>
                            <td>
                                <div class="ui green label">{{ $habitacion->situacion }}</div>
                            </td>
                            <td>                         
                                <div class="ui mini vertical animated blue button btn_seleccionar_habitacion" title="Seleccionar esta habitacion" data-id="{{ $habitacion->id_habitacion }}">
                                    <div class="hidden content">Elegir</div>
                                    <div class="visible content"><i class="check icon"></i></div>
                                </div>
                            </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
        </div>
    </div>
    <!--end buscar producto modal -->

@stop

@section('scripts')
    <script src="{{ asset('js/hospedar/transferir.js') }}"></script>
@stop


