@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REGISTRO DE HUESPEDES</h4>
            
            <div class="ui equal width grid">
                <div class="row">
                     <div class="column">
                        <form id="frmBuscar" autocomplete="off" method="GET" action="{{ url('huesped/buscar') }}" >
                            <div class="ui action small input" >
                                  <input type="text" placeholder="Buscar..." name="search">
                                  <button type="submit" class="ui icon button " title="Clic para buscar"><i class="search icon"></i></button>
                            </div>
                        </form>
                    </div>
                    <div class="column export_files" style="text-align: right">
                        <div class="ui right floated violet button btn_reporte"><i class="download icon"></i>Descargar lista</div>
                    </div> 
                   
                </div>
            </div>

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Nombre del Huesped</th>
                        <th class="head_table">Doc. Identidad</th>
                        <th class="head_table">Procedencia</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $huesped)
                    <tr data-table="{{ $huesped->id_huesped }}">
                        <td>{{ $i }}</td>
                        <td>{{ $huesped->nombre }}</td>
                        <td>{{ $huesped->dni}}</td>
                        <td>{{ $huesped->ciudad }} - {{ $huesped->pais }}</td>
                        <td>        
                            <div class="ui mini vertical animated positive button button_info_modal" title="Ver informacion detallada" data-id="{{ $huesped->id_huesped }}">
                                <div class="hidden content">Info</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </div>                    
                            <a class="ui mini vertical animated blue button" title="Editar datos" href="{{ url('huesped/editar/'.$huesped->id_huesped) }}">
                                <div class="hidden content">Editar</div>
                                <div class="visible content"><i class="pencil alternate  icon"></i></div>
                            </a>
                            <div class="ui mini vertical animated red button button_delete_modal" title="Eliminar registro" data-id="{{ $huesped->id_huesped }}">
                                <div class="hidden content">Eliminar</div>
                                <div class="visible content"><i class="trash alternate icon"></i></div>
                            </div>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="6">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot>
                
            </table>

        </div>
    </div>

    <!--start delete modal -->
    <div class="ui small basic modal" id="delete_modal">
        <div class="ui icon header"><i class="trash alternate icon"></i>Eliminar Registro</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere eliminar este registro del sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para eliminar"> <i class="checkmark icon"></i>Eliminar</div>
        </div>
    </div>
    <!--end delete modal -->

    <!--start details modal -->
    <div class="ui standard small modal" id="detalles_modal">
        <div class="header">Información del Huesped</div>
        <div class="image content">
            <div class="ui large circular image">
                <img id="url_avatar" src="">
            </div>
            <div class="description">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Nombre : </b></div>
                        <div class="eleven wide column"><span id="_1"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>N° Doc. Identidad : </b></div>
                        <div class="eleven wide column"><span id="_2"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Genero : </b></div>
                        <div class="eleven wide column"><span id="_3"></span></div>
                    </div>
                   <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>F. Nacimiento : </b></div>
                        <div class="eleven wide column"><span id="_4"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Telefono : </b></div>
                        <div class="eleven wide column"><span id="_5"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Email : </b></div>
                        <div class="eleven wide column"><span id="_6"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Ocupacion : </b></div>
                        <div class="eleven wide column"><span id="_7"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Pais : </b></div>
                        <div class="eleven wide column"><span id="_8"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Ciudad : </b></div>
                        <div class="eleven wide column"><span id="_9"></span></div>
                    </div>
                    
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="sixteen wide column"><h4 class="ui dividing header teal centered">Datos de la empresa que representa</h4></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Razon Social : </b></div>
                        <div class="eleven wide column"><span id="_10"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Ruc : </b></div>
                        <div class="eleven wide column"><span id="_11"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="text-align: right"><b>Direccion : </b></div>
                        <div class="eleven wide column"><span id="_12"></span></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="actions">
            <div class="ui primary right labeled icon deny button">Cerrar<i class="times icon"></i></div>
        </div>
    </div>
    <!--end details modal -->

@stop

@section('scripts')
    <script src="{{ asset('js/huesped/listar.js') }}"></script>
@stop


