<!DOCTYPE html>
<html lang="ES-es">
    <head>
        @include('layout.includes.head')
    </head>
    <body class="pushable"  style="overflow :hidden">
        
        <!--start sidebar-->
        @if (Auth::guard("usuario")->user()->id_rol == 1)
            @include('layout.includes.sidebar-admin')
        @elseif (Auth::guard("usuario")->user()->id_rol == 2)
            @include('layout.includes.sidebar-recepcion')  
        @elseif (Auth::guard("usuario")->user()->id_rol == 3)
            @include('layout.includes.sidebar-supervisor')  
        @endif
        
        <!--end sidebar-->

        <!--start pusher-->
        <div class="pusher" id="pusher" style="visibility:hidden">
            <!--start navbar--> 
            @include('layout.includes.navbar')
            <!--end navbar--> 

            <!--start content--> 
            <div class="ui equal width left aligned padded grid stackable centered">

                <div class="row">

                    @yield('content')

                </div>        
            </div>

            <!--end content--> 

        </div>
        <!--end pusher-->

        <!--start page loader-->
        <div id="loader">
            <div class="ui active dimmer" style="position: fixed;">
                <div class="ui big text loader ">Cargando...</div>
            </div>
        </div>
        <!--end page loader-->

        <!--start ajax loader-->
        <div class="ui disabled inverted dimmer ajax" id="ajax_loader" style="position: fixed;">
            <div class="ui large loader"></div>
        </div>
        <!--end ajax loader-->
                            
        <!--start footer-->
        @include('layout.includes.footer')
        <!--end footer-->

        <!--start content scripts-->
        @yield('scripts')
        <!--end content scripts-->


    </body>
</html>