@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REGISTRO DE SUCURSALES</h4>
            
            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Nombre</th>
                        <th class="head_table">Direccion</th>
                        <th class="head_table">Telefono</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = 1 /**/ ?>
                    @foreach ($data as $local)
                    <tr data-table="{{ $local->id_local }}">
                        <td>{{ $i }}</td>
                        <td>{{ $local->nombre }}</td>
                        <td>{{ $local->direccion }}</td>
                        <td>{{ $local->telefono }}</td>
                        <td>                            
                            <a class="ui mini vertical animated blue button" title="Editar datos" href="{{ url('sucursal/editar/'.$local->id_local) }}">
                                <div class="hidden content">Editar</div>
                                <div class="visible content"><i class="pencil alternate  icon"></i></div>
                            </a>
                            <div class="ui mini vertical animated red button button_delete_modal" title="Eliminar registro" data-id="{{ $local->id_local }}">
                                <div class="hidden content">Eliminar</div>
                                <div class="visible content"><i class="trash alternate icon"></i></div>
                            </div>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                
            </table>

        </div>
    </div>

    <!--start delete modal -->
    <div class="ui small basic modal" id="delete_modal">
        <div class="ui icon header"><i class="trash alternate icon"></i>Eliminar Registro</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere eliminar este registro del sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para eliminar"> <i class="checkmark icon"></i>Eliminar</div>
        </div>
    </div>
    <!--end delete modal -->

@stop

@section('scripts')
    <script src="{{ asset('js/local/listar.js') }}"></script>
@stop


