@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES NOTA ELECTRONICA EMITIDA</h4>

            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que registró la anulacion :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->usuario->nombres)) }} {{ ucwords(mb_strtolower($data->usuario->apellidos)) }} ({{ $data->usuario->username }})</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se registró la anulacion :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->created_at)) }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet  five wide computer column message_header">Tienda donde se realizó la anulacion:</div>
                        <div class="sixteen wide mobile eight wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->local->nombre)) }} ({{ ucwords(mb_strtolower($data->local->direccion)) }})</div>
                    </div>
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                   {{--  <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Nombre de Cliente :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column"><a href="{{ url('cliente/editar/'.$data->venta->id_cliente) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($data->venta->cliente->nombre)) }} ({{ $data->venta->cliente->tipo_documento->nombre }} : {{ $data->venta->cliente->numero_documento }})</a></div>
                    </div> --}}

                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Nombre de Cliente :</div>
                        <div class="sixteen wide mobile ten wide tablet  six wide computer column">{{ ucwords(mb_strtolower($data->venta->cliente->nombre)) }} </div>
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">{{ $data->venta->cliente->tipo_documento->nombre }} :</div>
                        <div class="sixteen wide mobile ten wide tablet  four wide computer column">{{ $data->venta->cliente->numero_documento }}</div>
                    </div>

                     <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  three wide computer column message_header">Direccion de Cliente:</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ ucwords(mb_strtolower($data->venta->cliente->direccion)) }}</div>
                    </div>
                </div>
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Tipo de Nota :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->tipo_comprobante->nombre }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">N° Nota :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->nombre_nota }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Emision :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->fecha_emision }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Monto Total Afectado :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ {{ $data->venta->total_venta }}</div>
                    </div>
                   

                    @if($data->estado_envio == "REGISTRADO")
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Mensaje de envio a SUNAT :</div>
                        <div class="sixteen wide mobile eight wide tablet  twelve wide computer column">PENDIENTE - El comprobante se encuentra pendiente de envio a la SUNAT</div>                    
                    </div>
                    @else
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Mensaje de envio a SUNAT :</div>
                        <div class="sixteen wide mobile eight wide tablet  twelve wide computer column">{{ ($data->estado_envio) }} - {{ $data->mensaje_envio }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Envio:</div>
                        <div class="sixteen wide mobile eight wide tablet  twelve wide computer column">{{ ($data->updated_at) }}</div>
                    </div>
                    @endif
                    

                </div>
            </div>
            
            @if($data->id_tipo_comprobante == 3)
            <div class="ui error message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Comprobante Anulado :</div>
                        <div class="sixteen wide mobile eight wide tablet three wide computer column"><a href="{{ url('electronico/detalles/'.$data->id_venta) }}" title="Clic para ver informacion">{{ $data->venta->nombre_comprobante }}</a></div>

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha del Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet five wide computer column">{{ $data->venta->fecha_venta}}</div>
                    </div>    
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Motivo de anulacion :</div>
                        <div class="sixteen wide mobile eight wide tablet three wide computer column">{{ $data->motivo }}</div>

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Descripcion del motivo :</div>
                        <div class="sixteen wide mobile eight wide tablet five wide computer column">{{ $data->descripcion }}</div>
                    </div>
                </div>
            </div>
            @elseif($data->id_tipo_comprobante == 4)
            <div class="ui error message">
                <div class="ui equal width grid">

                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Comprobante Modificado :</div>
                        <div class="sixteen wide mobile eight wide tablet three wide computer column"><a href="{{ url('electronico/detalles/'.$data->id_venta) }}" title="Clic para ver informacion">{{ $data->venta->nombre_comprobante }}</a></div>

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha del Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet five wide computer column">{{ $data->venta->fecha_venta}}</div>
                    </div>    
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Motivo de modificacion :</div>
                        <div class="sixteen wide mobile eight wide tablet three wide computer column">{{ $data->motivo }}</div>

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Descripcion del motivo :</div>
                        <div class="sixteen wide mobile eight wide tablet five wide computer column">{{ $data->descripcion }}</div>
                    </div>

                </div>
            </div>
            @endif


            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Cantidad</th>
                        <th class="center aligned">Concepto</th>
                        <th class="center aligned" data-tooltip="Precio de venta" data-position="top center" data-inverted="">Precio S/</th>
                        <th class="center aligned">Subtotal</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    @foreach ($detalle_venta as $venta)
                    <tr data-table="{{ $venta->id_detalle_venta }}">
                        <td>{{ $venta->cantidad}}</td>
                        <td>{{ $venta->descripcion }}</td>
                        <td>{{ $venta->precio_venta }}</td>
                        <td class="warning">{{ $venta->precio_venta_total }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>
                @if($data->estado_envio != "ACEPTADO" && $data->estado_envio != "RECHAZADO" && $data->venta->id_tipo_comprobante == 1 && $data->venta->estado_envio == "ACEPTADO")
                <div class="ui small right floated red button btn_reenviar" data-id="{{$data->id_nota}}"><i class="sync alternate icon"></i>Reenviar</div>
                @endif
                @if( ($data->estado_envio == "ACEPTADO" || $data->estado_envio == "RECHAZADO") && $data->venta->id_tipo_comprobante == 1)
                <a class="ui small right floated primary button" href="{{ url('../sunat/cdr/notas/R-'.$empresa->ruc.'-'.$data->tipo_comprobante->codigo.'-'.$data->nombre_nota.'.xml') }}" target="_blank"><i class="download icon"></i>Descargar CDR</a>
                @endif
                @if($data->estado_envio == "NO ENVIADO" && $data->venta->id_tipo_comprobante == 1)
                    <div class="ui small right floated orange button btn_cdr" data-id="{{$data->id_nota}}"><i class="sync alternate icon"></i>Obtener CDR</div>
                @endif 
                <a class="ui small right floated green button" href="{{ url('../sunat/xml/notas/'.$empresa->ruc.'-'.$data->tipo_comprobante->codigo.'-'.$data->nombre_nota.'.xml') }}" target="_blank"><i class="download icon"></i>Descargar XML</a>
            </div>  

        </div>
    </div>

@stop

@section('scripts')
    <script src="{{ asset('js/nota/detalles.js') }}"></script>
@stop




