@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE PROFORMA</h4>

            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que registró la proforma :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->usuario->nombres)) }} {{ ucwords(mb_strtolower($data->usuario->apellidos)) }} ({{ $data->usuario->username }})</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se registró la proforma :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->created_at)) }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet  five wide computer column message_header">Tienda donde se realizó la proforma:</div>
                        <div class="sixteen wide mobile eight wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->local->nombre)) }} ({{ ucwords(mb_strtolower($data->local->direccion)) }})</div>
                    </div> 
                </div>
            </div>    


            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Nombre de Cliente :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ $data->nombre }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">DNI / RUC de Cliente :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ $data->numero_documento }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  three wide computer column message_header">Direccion de Cliente :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ ucwords(mb_strtolower($data->direccion)) }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  three wide computer column message_header">Observacion :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ $data->observacion }}</div>
                    </div>
                </div> 
            </div>


            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Emision :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->fecha_emision }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Monto Total :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ {{ $data->total }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Monto que dejo de adelanto :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ {{ $data->adelanto != null ? $data->adelanto : '0.00' }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Saldo pendiente por cobrar :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ {{ $data->saldo != null ? $data->saldo : '0.00' }}</div>
                    </div>
                </div>
            </div> 

            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Concepto</th>
                        <th class="center aligned" data-tooltip="Cantidad vendida" data-position="top center" data-inverted="">Cantidad</th>
                        <th class="center aligned" data-tooltip="Precio de venta" data-position="top center" data-inverted="">Precio S/</th>
                        <th class="center aligned">Subtotal S/</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    @foreach ($detalle_proforma as $venta)
                    <tr data-table="{{ $venta->id_detalle_proforma }}">
                        <td>{{ $venta->descripcion }}</td>
                        <td>{{ $venta->cantidad }}</td>
                        <td>{{ $venta->precio }}</td>
                        <td class="warning">{{ $venta->subtotal }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>

                <div class="ui small right floated primary button btn_imprimir" data-id="{{ $data->id_proforma }}"><i class="print icon"></i>Imprimir Ticket</div>
                <div class="ui small right floated green button btn_imprimir_a4" data-id="{{ $data->id_proforma }}"><i class="print icon"></i>Imprimir A4</div> 
                <a class="ui small right floated violet button" href="{{ url('venta/proforma_venta/'.$data->id_proforma) }}"><i class=" sign dollar icon"></i>Emitir Comprobante</a> 
                {{-- <div class="ui small right floated green button btn_enviar"><i class="paper plane icon"></i>Enviar Correo</div> --}}
            </div>  

        </div>
    </div>

@stop

@section('scripts')
    <script src="{{ asset('js/proforma/detalles.js') }}"></script>
@stop


