@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">EMITIR COMPROBANTE</h4>
            
            <form class="ui form" id="frmNuevo" autocomplete="off"> 
                
                <div class="inline four fields">
                    <div class="ten wide field">
{{--                         <a href="#" id="btn_modal_guia" title="Haga clic para abrir ventana para llenar datos de la guia de remision">Datos para Guia de Remisión</a>
 --}}                    </div>

                    <div class="field datos_comprobante" >
                        <input type="hidden" id="tipo_comprobante" name="id_tipo_comprobante" value="1">
                        <input type="hidden" id="tipo_documento" name="id_tipo_documento" value="1">

                        <div class="ui fluid tiny black button pointing dropdown item" id="select_comprobante_venta">
                            <span class="text">FACTURA</span><i class="dropdown icon"></i>
                            <div class="menu border_shadow">
                                @foreach($tipo_comprobante as $data)
                                <div class="item" data-value="{{ $data->id_tipo_comprobante }}">{{ $data->nombre }}</div>
                                @endforeach 
                            </div>
                        </div>
  
                        <div class="ui large white label" id="serie_comprobante">{{ $serie }}</div>-
                        <div class="ui large white label" id="numero_comprobante">{{ $numero }}</div>             
                    </div>
                    <div class="two wide field"></div>
                </div>
                <br>

                <div class="four fields">
                    <div class="three wide field">
                        <div class="ui fluid large white label" id="tipo_doc">RUC</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui action small input" >
                              <input type="text" id="numero_documento" name="numero_documento"  value="{{ $proforma->numero_documento }}"  maxlength="11">
                              <div class="ui icon button" id="loading_doc" title="Clic para buscar"><i class="search icon"></i></div>
                        </div>
                    </div>
                </div>

                <div class="three fields">
                    <div class="three wide field">
                        <div class="ui fluid large white label" id="nomb">Razon Social</div>
                    </div>
                    <div class="eleven wide field">
                        <div class="ui small input">
                            <input type="text" id="nombre_cliente" name="nombre" value="{{ $proforma->nombre }}" maxlength="200" oninput="$.upperCase(this)">
                        </div>  
                    </div>
                    <div class="two wide field">
                        <div class="ui fluid small green button btn_buscar_cliente" title="Clic para ver lista de clientes registrados"><i class="search icon"></i>BUSCAR</div>
                    </div>
                </div>

                <div class="three fields">
                    <div class="three wide field">
                        <div class="ui fluid large white label">Direccion del cliente</div>
                    </div>
                    <div class="eleven wide field">
                        <div class="ui small input" id="dir_dis">
                            <input type="text" name="direccion" id="direccion" value="{{ $proforma->direccion }}" maxlength="100" oninput="$.upperCase(this)">
                        </div>  
                    </div>
                </div>

                <div class="five fields">
                    {{-- <div class="three wide field">
                        <div class="ui fluid large white label">Fecha de Emision</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input">
                            <input type="text" class="fecha hasDate" name="fecha_venta" >
                        </div> 
                    </div> --}}
                    <div class="three wide field">
                        <div class="ui fluid large white label">Tipo de Pago</div>
                    </div>
                    <div class="three wide field">
                        <select class="ui fluid small input dropdown" name="tipo_pago">
                            <option value="EFECTIVO">Pago en Efectivo</option>
                            <option value="TARJETA">Pago con Tarjeta</option>
                            <option value="CREDITO">Venta al Credito</option>
                        </select> 
                    </div>
                    <div class="three wide field" id="fecha_pago" style="visibility: hidden;">
                        <div class="ui small input">
                            <input type="text" class="fecha_fut" name="fecha_pago" readonly placeholder="Fecha de vencimiento">
                        </div> 
                    </div>
                </div>
               
                <br><br>
                    
                <table class="ui celled table">
                    <thead>
                        <tr>
                            <th class="center aligned">Cantidad</th>
                            <th class="center aligned">Concepto</th>
                            <th class="center aligned" data-tooltip="Monto a facturar" data-position="top center" data-inverted="">Monto S/</th>
                            {{-- <th class="center aligned" data-tooltip="Monto para descuento" data-position="top center" data-inverted="">Dscto S/</th> --}}
                            <th class="center aligned">Subtotal S/</th>
                            <th class="center aligned">Acción</th>
                        </tr>
                    </thead>
                    <tbody id="tbody">

                        
                    </tbody>
                </table>

                <div class="form_footer">
                    <div class="ui labeled small input">
                        <label class="ui brown label">TOTAL  S/</label>
                        <input type="text" name="total_venta" id="total_venta" size="5" readonly style="width: 0%">
                    </div> 
                    &nbsp;&nbsp;
                    <a href="#" class="btn_nuevo_concepto">(+) Agregar nuevo concepto</a>
                    <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>EMITIR COMPROBANTE</div>
                </div>

            </form>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="circular inverted white dollar sign icon"></i>Emitir Comprobante</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea emitir el comprobante?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para emitir comprobante"> <i class="checkmark icon"></i>Emitir</div>
        </div>
    </div>
    <!--end register modal -->

    <!--start buscar cliente modal -->
    <div class="ui standard large modal" id="buscar_cliente_modal">
        <div class="header">Buscar Clientes</div>
        <div class="scrolling content">
  
            <div class="ui action small input"  autocomplete="off">
                <input type="text" id="buscar_cliente" name="buscar_cliente" placeholder="Cliente a buscar...">
                <div class="ui icon button" id="btn_buscar_cli" title="Clic para buscar"><i class="search icon"></i></div>
            </div> 
            <table class="ui celled striped table" id="tabla_clientes">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Nombre</th>
                        <th class="head_table">Documento</th>
                        <th class="head_table">Numero</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody id="tbody_clientes">
                   <?php /**/ $i = 1/**/ ?>
                    @foreach ($clientes as $row)
                    <tr data-table="{{ $row->id_cliente }}">
                        <td>{{ $i }}</td>
                        <td>{{ $row->nombre }}</td>
                        <td>{{ $row->tipo_documento->nombre }}</td>
                        <td>{{ $row->numero_documento}}</td>

                        <td>                            
                            <div class="ui mini vertical animated positive button btn_seleccionar_cliente" title="Seleccionar este cliente" data-nombre="{{ $row->nombre}}" data-documento="{{ $row->numero_documento }}" data-direccion="{{ $row->direccion }}">
                                <div class="hidden content">Elegir</div>
                                <div class="visible content"><i class="check icon"></i></div>
                            </div>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="actions" >
            <div class="ui left floated red right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
        </div>
    </div>
    <!--end buscar cliente modal -->


@stop

@section('scripts')
    
   


    <script type="text/javascript">

        var valor_impuesto = {!!$empresa->valor_impuesto!!};

        $(function () {

            @foreach ($detalle_proforma as $detalle)
                    
                    var filas = contarFilas();
                    var id = asignaId(filas);
                    agregarTabla();

                    conc = "{!!$detalle->descripcion!!}";
                    cant = {!!$detalle->cantidad!!};
                    desc = {!!$detalle->descuento!!};
                    prec = {!!$detalle->precio!!};

                    $('#conc'+id ).val(conc);
                    $('#desc'+id ).val(desc);
                    $('#cant'+id ).val(cant);
                    $('#prec'+id ).val(prec);
                    calculaSubtotal(id , valor_impuesto);
                    calcularTotal();
            
            @endforeach
      
        }); 
                  
        
    </script>

     <script src="{{ asset('js/proforma/venta.js') }}"></script>

    
@stop
