@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE VENTAS DE HOY POR PERSONAL</h4>
            
           <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Nombre del Personal :</div>
                        <div class="sixteen wide mobile nine wide tablet  seven wide computer column">{{ ucwords(mb_strtolower($usuario->nombres)) }} {{ ucwords(mb_strtolower($usuario->apellidos)) }} ({{ $usuario->username }})</div>
                        <div class="sixteen wide mobile seven wide tablet  two wide computer column message_header">DNI :</div>
                        <div class="sixteen wide mobile nine wide tablet  two wide computer column">{{ $usuario->dni }}</div>
                    </div>
                </div>
            </div>    

            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">N°</th>
                        <th class="center aligned">Local</th>
                        <th class="center aligned">Cliente</th>
                        <th class="center aligned">Comprobante</th>
                        <th class="center aligned">Monto S/</th>
                        <th class="center aligned">Fecha Venta</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    <?php /**/ $i = 1 /**/ ?>
                    @foreach ($data as $venta)
                    <tr data-table="{{ $venta->id_venta }}">
                        <td>{{ $i }}</td>
                        <td>{{ $venta->local->nombre }}</td>
                        <td>{{ $venta->cliente->nombre }}</td>
                        <td><a href="{{ url('venta/detalles/'.$venta->id_venta) }}" title="Clic para ver informacion">{{ $venta->nombre_comprobante }}</a></td>
                        <td>{{ $venta->total_venta }}</td>
                        <td>{{ $venta->created_at }}</td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>
            </div>  

        </div>
    </div>

@stop




