@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE RESERVA</h4>

            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que registró la reserva :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ $data->usuario  ? (ucwords(mb_strtolower($data->usuario->nombres)).' '. ucwords(mb_strtolower($data->usuario->apellidos))) : 'No especificado' }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se registró la reserva :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->created_at)) }}</div>
                    </div>
                    {{-- <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet  five wide computer column message_header">Local donde se emitio el comprobante:</div>
                        <div class="sixteen wide mobile eight wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->local->nombre)) }} ({{ ucwords(mb_strtolower($data->local->direccion)) }})</div>
                    </div>  --}}
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Nombre del Visitante :</div>
                        <div class="sixteen wide mobile ten wide tablet  six wide computer column">{{ ucwords(mb_strtolower($data->nombre)) }}</div>
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">N° de Documento :</div>
                        <div class="sixteen wide mobile ten wide tablet  four wide computer column">{{ $data->dni }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  three wide computer column message_header">Telefono :</div>
                        <div class="sixteen wide mobile ten wide tablet  six wide computer column">{{ $data->telefono }}</div>
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Email :</div>
                        <div class="sixteen wide mobile ten wide tablet  four wide computer column">{{ $data->email }}</div>
                    </div>
                </div>
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">

                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet three wide computer column message_header">Fecha de Llegada :</div>
                        <div class="sixteen wide mobile eight wide tablet six wide computer column">{{ $data->fecha_llegada }}</div>
                        <div class="sixteen wide mobile eight wide tablet three wide computer column message_header">Medio de Reserva :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"> {{ ucwords(mb_strtolower($data->medio))  }}</div>
                    </div>

                </div>
            </div>
            
            @if($data->observacion == 'CANCELADO')
            <div class="ui error message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">ESTADO DE LA RESERVA :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->observacion }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Cancelacion :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->updated_at }}</div>
                    </div>
                </div>
            </div>
            @endif

            <div class="ui hidden divider"></div>

            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Numero</th>
                        <th class="center aligned">Estado Actual de Habitacion</th>
                        <th class="center aligned">Tipo</th>
                        <th class="center aligned">Precio</th>
                    </tr>
                </thead>
                <tbody id="tbody">

                    <tr>
                        <td><div class="ui violet label">{{ $data->habitacion->numero }}</div></td>
                        <td>@if($data->habitacion->situacion == "DISPONIBLE")
                                <div class="ui green label">{{ $data->habitacion->situacion }}</div>
                            @elseif ($data->habitacion->situacion == "MANTENIMIENTO")
                                <div class="ui yellow label">{{ $data->habitacion->situacion }}</div>
                            @elseif ($data->habitacion->situacion == "OCUPADO")
                                <div class="ui red label">{{ $data->habitacion->situacion }}</div>
                            @endif
                        </td> 
                        <td>{{ $data->habitacion->tipo_habitacion->nombre }}</td>
                        <td>{{ $data->habitacion->precio }}</td>
                    </tr>

                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>

                {{-- @if($data->id_nota == null && $data->id_cliente != 1 && $data->estado_envio == 'ACEPTADO') --}}
                @if($data->observacion == 'PENDIENTE')
                    <div class="ui small right floated red button button_delete_modal" data-id="{{ $data->id_reserva }}"><i class="times icon"></i>Cancelar Reserva</div>
                    <a class="ui small right floated green button" href="{{ url('reserva/ocupar/'.$data->id_reserva) }}"><i class="check icon"></i>Registrar en Habitacion</a>
                @endif

            </div>  

        </div>
    </div>

    <!--start delete modal -->
    <div class="ui small basic modal" id="delete_modal">
        <div class="ui icon header"><i class="trash alternate icon"></i>Cancelar Reserva</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere cancelar esta reservacion?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Salir</div>
            <div class="ui green ok inverted button" title="Haga clic para eliminar"> <i class="checkmark icon"></i>Cancelar Reserva</div>
        </div>
    </div>
    <!--end delete modal -->


 
@stop

@section('scripts')
    <script src="{{ asset('js/reserva/detalles.js') }}"></script>
@stop


