@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">LISTADO DE RESERVAS PENDIENTES</h4>

            <div class="ui equal width grid">
                <div class="row">
                     <div class="column">
                        <form id="frmBuscar" autocomplete="off" method="GET" action="{{ url('reserva/buscar') }}" >
                            <div class="ui action small input" >
                                  <input type="text" placeholder="Buscar..." name="search">
                                  <button type="submit" class="ui icon button " title="Clic para buscar"><i class="search icon"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Habitacion</th>
                        <th class="head_table">Estado</th>
                        <th class="head_table">Nombre del Visitante</th>
                        <th class="head_table">Fecha de Llegada</th>
                        
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $reserva)
                    <tr data-table="{{ $reserva->id_reserva }}">
                        <td>{{ $i }}</td>
                        <td><div class="ui violet label">{{ $reserva->habitacion->numero }}</div></td>
                        <td>{{ $reserva->habitacion->situacion }}</td> 
                        <td>{{ $reserva->nombre }}</td>
                        <td>{{ $reserva->fecha_llegada }}</td>
                        <td>                        
                            <a class="ui mini vertical blue button" title="Ver Detalles" href="{{ url('reserva/detalles/'.$reserva->id_reserva) }}">
                                    <div class="visible content"><i class="search icon"></i> Ver Detalles</div>
                                </a>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="6">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot> 
                
            </table>

        </div>
    </div>


@stop


