@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet thirteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REGISTRAR NUEVA RESERVA</h4>
            <br>

            <form class="ui form" id="frmNuevo" autocomplete="off">
               
                <div class="four fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Seleccione la Habitacion</div>
                    </div>
                    <div class="six wide field">
                        <select class="ui small search selection dropdown" name="id_habitacion">
                            <option value="">Seleccione...</option>
                            @foreach($habitaciones as $data)
                               <option value="{{ $data->id_habitacion}}">{{ $data->numero }} - {{ $data->tipo_habitacion->nombre }}</option>
                            @endforeach 
                        </select> 
                    </div>
                    
                    <div class="four wide field">
                        <div class="ui fluid small green button btn_buscar_habitacion" title="Clic para ver lista de habitaciones"><i class="search icon"></i>Buscar Habitacion</div>
                    </div>
                </div>

                <div class="three fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Nombre del Visitante</div>
                    </div>
                    <div class="ten wide field">
                        <div class="ui small input ">
                          <input type="text" name="nombre" maxlength="100" oninput="$.upperCase(this)">
                        </div>
                    </div>
                </div>

                <div class="five fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Documento de Identidad</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input ">
                          <input type="text" name="dni" maxlength="15" placeholder="N° DNI" oninput="$.upperCase(this)">
                        </div>
                    </div>
                    <div class="three wide field">
                        <div class="ui fluid large white label">Telefono</div>
                    </div>
                    <div class="four wide field">
                        <div class="ui small input ">
                          <input type="text" name="telefono" maxlength="20"  oninput="$.upperCase(this)">
                        </div>
                    </div>
                </div>

                <div class="five fields">
                   <div class="four wide field">
                        <div class="ui fluid large white label">Fecha de Llegada</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input">
                            <input type="text" class="fecha_fut_hora  hasDate" name="fecha_llegada" >
                        </div> 
                    </div>

                    <div class="three wide field">
                        <div class="ui fluid large white label">Medio de Reserva</div>
                    </div>
                    <div class="four wide field">
                        <select class="ui small search selection dropdown" name="medio">
                            <option value="">Seleccione...</option>
                            <option value="TELEFONICAMENTE">Via Telefonica</option>
                            <option value="PERSONALMENTE">Se acerco personalmente</option>
                            <option value="RESERVA POR PAGINA WEB">Mediante Pagina Web</option>
                            <option value="MEDIANTE OTROS MEDIOS">Por Otros Medios</option>
                        </select> 
                    </div>

                    
                </div>



                <div class="form_footer">
                    <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>REGISTRAR</div>
                </div>  


            </form>

        </div>
    </div>
    
    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="check circle icon"></i>Registrar Información</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea registrar esta información en el sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para registrar"> <i class="checkmark icon"></i>Registrar</div>
        </div>
    </div>
    <!--end register modal -->

        <!--start buscar producto modal -->
    <div class="ui standard large modal" id="buscar_habitacion_modal">
        <div class="header">Buscar Habitacion</div>
        <div class="scrolling content">
            <div class="ui disabled inverted dimmer" id="loader_busqueda">
                <div class="ui text loader">Procesando...</div>
            </div>

            <div class="ui action small input"  autocomplete="off">
                <input type="text" id="buscar_habitacion_disponibles" placeholder="Numero de habitacion">
                <div class="ui icon button" id="btn_buscar_habitacion_disponibles" title="Clic para buscar"><i class="search icon"></i></div>
            </div>


            <table class="ui celled striped table" id="tabla_disponibles">
                <thead>
                    <tr>
                        <th class="head_table">Numero</th>
                        <th class="head_table">Tipo</th>
                        <th class="head_table">Precio S/</th>
                        <th class="head_table">Estado</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody id="tbody_productos">
                    @foreach ($habitaciones as $habitacion)
                    <tr data-table="{{ $habitacion->id_habitacion }}">
                            <td><div class="ui violet label">{{ $habitacion->numero }}</div></td>
                            <td>{{ $habitacion->tipo_habitacion->nombre }}</td>
                            <td>{{ $habitacion->precio }}</td>
                            <td>
                                @if ($habitacion->situacion == "DISPONIBLE")
                                <div class="ui green label">{{ $habitacion->situacion }}</div>
                                @elseif ($habitacion->situacion == "OCUPADO")
                                <div class="ui red label">{{ $habitacion->situacion }}</div>
                                @elseif ($habitacion->situacion == "MANTENIMIENTO")
                                <div class="ui yellow label">{{ $habitacion->situacion }}</div>
                                @endif
                                
                            </td>
                            <td>                         
                                <div class="ui mini vertical animated blue button btn_seleccionar_habitacion" title="Seleccionar esta habitacion" data-id="{{ $habitacion->id_habitacion }}">
                                    <div class="hidden content">Elegir</div>
                                    <div class="visible content"><i class="check icon"></i></div>
                                </div>
                            </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
        </div>
    </div>
    <!--end buscar producto modal -->
@stop

@section('scripts')
    <script src="{{ asset('js/reserva/nuevo.js') }}"></script>
@stop


