@extends('layout.main')
@section('content')
    
    @if ($data)
        <div class="sixteen wide tablet fifteen wide computer column ">
            <div class="ui segment">
                
                <h4 class="ui dividing header teal centered">EDITAR DATOS DE PERSONAL</h4>
                <br>

                <form class="ui form" id="frmEditar" autocomplete="off">
                    <input type="hidden" id="id_usuario" name="id_usuario" value="{{ $data->id_usuario }}">

                    <div class="two fields">
                        <div class="field">
                            <label>Nombres</label>
                            <div class="ui small input ">
                              <input type="text" name="nombres" maxlength="50" oninput="$.upperCase(this)" value="{{$data->nombres}}">
                            </div>
                        </div>
                        <div class="field">
                            <label>Apellidos</label>
                            <div class="ui small input ">
                              <input type="text" name="apellidos" maxlength="50" oninput="$.upperCase(this)" value="{{$data->apellidos}}">
                            </div>
                        </div>
                    </div>

                    <div class="two fields">
                        <div class="field">
                            <label>Usuario</label>
                            <div class="ui small input">
                              <input type="text" name="username" maxlength="20" value="{{$data->username}}">
                            </div>
                        </div>
                        <div class="field">
                            <label>DNI</label>
                            <div class="ui small input ">
                              <input type="text" name="dni" maxlength="8" value="{{$data->dni}}">
                            </div>
                        </div>
                    </div>

                    <div class="two fields">
                        <div class="field">
                            <label>Fecha de Nacimiento</label>
                            <div class="ui small input ">
                              <input type="text" name="fecha_nacimiento" class="fecha_pas" value="{{$data->fecha_nacimiento}}">
                            </div>
                        </div>
                        <div class="field">
                            <label>Domicilio</label>
                            <div class="ui small input " >
                              <input type="text" name="domicilio" maxlength="100" oninput="$.upperCase(this)" value="{{$data->domicilio}}">
                            </div>
                        </div>
                    </div>   

                    <div class="two fields">
                        <div class="field">
                            <label>Telefono</label>
                            <div class="ui small input ">
                              <input type="text" name="telefono" maxlength="15" value="{{$data->telefono}}">
                            </div>
                        </div>
                        <div class="field">
                            <label>Email</label>
                            <div class="ui small input ">
                              <input type="email" name="email" maxlength="50" value="{{$data->email}}">
                            </div>
                        </div>
                    </div> 
                  
                    <div class="two fields">
                        <div class="field">
                            <label>Rol</label>
                            <select class="ui small input dropdown" name="id_rol">
                                @foreach($roles as $rol)
                                    @if($rol->id_rol == $data->id_rol)
                                        <option value="{{ $rol->id_rol }}" selected> {{ $rol->nombre }} </option>
                                    @else
                                        <option value="{{ $rol->id_rol }}"> {{ $rol->nombre }} </option>
                                    @endif
                                @endforeach
                            </select>  
                        </div>
                        <div class="field">
                            <label>Lugar de Trabajo</label>
                            <select class="ui small input dropdown" name="id_local">
                                @foreach($locales as $local)
                                    @if($local->id_local == $data->id_local)
                                        <option value="{{ $local->id_local }}" selected> {{ $local->nombre }} ({{ ucwords(mb_strtolower($local->direccion ))}})</option>
                                    @else
                                        <option value="{{ $local->id_local }}"> {{ $local->nombre }} ({{ ucwords(mb_strtolower($local->direccion ))}})</option>
                                    @endif
                                @endforeach
                            </select>  
                        </div>
                    </div>  

                    <div class="form_footer" >
                        <a class="ui left floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>
                        <div class="ui right floated primary button btn_guardar"><i class="save icon"></i>GUARDAR</div>
                    </div>    
                </form>

            </div>
        </div>

        <!--start update modal -->
        <div class="ui small basic modal" id="update_modal">
            <div class="ui icon header"><i class="paper plane icon"></i>Guardar cambios</div>
            <div class="content" style="text-align: center; font-size: 16px">
              <p>¿Está seguro que quiere guardar los cambios que hizo?</p>
            </div>
            <div class="actions">
                <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
                <div class="ui green ok inverted button" title="Haga clic para guardar cambios"> <i class="checkmark icon"></i>Guardar</div>
            </div>
        </div>
        <!--end update modal -->
    @else
        <div class="sixteen wide tablet fifteen wide computer column ">
            <div class="ui segment">
                <h3 class="ui header black centered">No se encuentra el registro que desea editar</h3>
            </div>
        </div>    
    @endif

@stop

@section('scripts')
    <script src="{{ asset('js/usuario/editar.js') }}"></script>
@stop


