@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet fifteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REGISTRAR PERSONAL</h4>
            <br>

            <form class="ui form" id="frmNuevo" autocomplete="off">
                <div class="two fields">
                    <div class="field">
                        <label>Nombres</label>
                        <div class="ui small input ">
                          <input type="text" name="nombres" maxlength="50" oninput="$.upperCase(this)">
                        </div>
                    </div>
                    <div class="field">
                        <label>Apellidos</label>
                        <div class="ui small input ">
                          <input type="text" name="apellidos" maxlength="50" oninput="$.upperCase(this)">
                        </div>
                    </div>
                </div>

                <div class="two fields">
                    <div class="field">
                        <label>Usuario</label>
                        <div class="ui small input">
                          <input type="text" name="username" maxlength="20">
                        </div>
                    </div>
                    <div class="field">
                        <label>Contraseña</label>
                        <div class="ui small input ">
                          <input type="password" name="password" maxlength="50">
                        </div>
                    </div>
                </div>

                <div class="two fields">
                    <div class="field">
                        <label>DNI</label>
                        <div class="ui small input ">
                          <input type="text" name="dni" maxlength="8">
                        </div>
                    </div>
                    <div class="field">
                        <label>Fecha de Nacimiento</label>
                        <div class="ui small input ">
                          <input type="text" name="fecha_nacimiento" class="fecha_pas">
                        </div>
                    </div>
                </div>   

                <div class="two fields">
                    <div class="field">
                        <label>Domicilio</label>
                        <div class="ui small input " >
                          <input type="text" name="domicilio" maxlength="100" oninput="$.upperCase(this)">
                        </div>
                    </div>
                    <div class="field">
                        <label>Telefono</label>
                        <div class="ui small input ">
                          <input type="text" name="telefono" maxlength="15">
                        </div>
                    </div>
                </div> 

                <div class="two fields">
                     <div class="field">
                        <label>Email</label>
                        <div class="ui small input ">
                          <input type="text" name="email" maxlength="50">
                        </div>
                    </div>
                    <div class="field">
                        <label>Genero</label>
                        <select class="ui small input dropdown" name="genero">
                            <option value="">Seleccione</option>
                            <option value="Masculino">Masculino</option>
                            <option value="Femenino">Femenino</option>
                        </select>  
                    </div>
                </div>

                <div class="two fields">
                    <div class="field">
                        <label>Rol</label>
                        <select class="ui small input dropdown" name="id_rol">
                            <option value="">Seleccione</option>
                            @foreach($roles as $rol)
                               <option value="{{ $rol->id_rol }}"> {{ $rol->nombre }} </option>
                            @endforeach
                        </select>  
                    </div>
                    <div class="field">
                        <label>Lugar de Trabajo</label>
                        <select class="ui small input dropdown" name="id_local">
                            <option value="">Seleccione</option>
                            @foreach($locales as $local)
                               <option value="{{ $local->id_local }}"> {{ $local->nombre }} ({{ ucwords(mb_strtolower($local->direccion ))}})</option>
                            @endforeach
                        </select>  
                    </div>
                </div>  

                <div class="form_footer">
                    <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>REGISTRAR</div>
                </div>    
            </form>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="check circle icon"></i>Registrar Información</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea registrar esta información en el sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para registrar"> <i class="checkmark icon"></i>Registrar</div>
        </div>
    </div>
    <!--end register modal -->
    
@stop

@section('scripts')
    <script src="{{ asset('js/usuario/nuevo.js') }}"></script>
@stop


