@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE VENTA AL CREDITO</h4>
            
            <input type="hidden" id="id_venta" value="{{$data->id_venta}}">

            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que registró la venta :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->usuario->nombres)) }} {{ ucwords(mb_strtolower($data->usuario->apellidos)) }} ({{ $data->usuario->username }})</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se registró la venta :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->created_at)) }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet  five wide computer column message_header">Tienda donde se realizó la venta:</div>
                        <div class="sixteen wide mobile eight wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->local->nombre)) }} ({{ ucwords(mb_strtolower($data->local->direccion)) }})</div>
                    </div>
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Nombre de Cliente :</div>
                        <div class="sixteen wide mobile ten wide tablet  six wide computer column">{{ ucwords(mb_strtolower($data->cliente->nombre)) }} </div>
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">{{ $data->cliente->tipo_documento->nombre }} :</div>
                        <div class="sixteen wide mobile ten wide tablet  four wide computer column">{{ $data->cliente->numero_documento }}</div>
                    </div>
                     <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  three wide computer column message_header">Direccion de Cliente:</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ ucwords(mb_strtolower($data->cliente->direccion)) }}</div>
                    </div>
                </div>
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Tipo de Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->tipo_comprobante->nombre }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">N° Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->nombre_comprobante }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Venta :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->fecha_venta }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Monto de la DEUDA :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ {{ $data->total_venta }}</div>
                    </div>
                    
                    @if ($data->id_nota != null)
                        <div class="row" style="padding-bottom: 0px !important">
                            <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Estado de comprobante:</div>
                            <div class="sixteen wide mobile eight wide tablet  twelve wide computer column" style="color: red!important">El comprobante fue ANULADO  <a style="text-decoration: underline;" href="{{ url('nota/detalles/'.$data->id_nota) }}">(ver detalles)</a></div>
                        </div>
                    @endif

                    

                </div>
            </div>
            
            @if($data->tipo_pago == 'CREDITO')
            <div class="ui error message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Tipo de Venta :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">AL {{ $data->tipo_pago }}</div>

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha a cobrar la deuda:</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->fecha_pago }}</div>
                    </div>
                </div>
            </div>
            @endif

            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Cantidad</th>
                        <th class="center aligned">Concepto</th>
                        <th class="center aligned" data-tooltip="Precio de venta" data-position="top center" data-inverted="">Precio S/</th>
                        <th class="center aligned">Subtotal</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    @foreach ($detalle_venta as $venta)
                    <tr data-table="{{ $venta->id_detalle_venta }}">
                        <td>{{ $venta->cantidad }}</td>
                        <td>{{ $venta->descripcion }}</td>
                        <td>{{ $venta->precio_venta }}</td>
                        <td class="warning">{{ $venta->precio_venta_total }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>
                {{-- @if($data->id_nota == null && $data->id_cliente != 1 && $data->estado_envio == 'ACEPTADO') --}}
                @if($data->tipo_pago == 'CREDITO')
                    <div class="ui small right floated red button btn_anular_deuda" data-id="{{ $data->id_venta }}"><i class="times icon"></i>Anular deuda</div>
                @endif

                {{-- <div class="ui small right floated green button btn_enviar"><i class="paper plane icon"></i>Enviar Correo</div> --}}
            </div>  

        </div>
    </div>

    <!--start update modal -->
        <div class="ui small basic modal" id="update_modal">
            <div class="ui icon header"><i class="paper plane icon"></i>Anular Deuda</div>
            <div class="content" style="text-align: center; font-size: 16px">
              <p>¿Está seguro que quiere anular esta deuda?</p>
            </div>
            <div class="actions">
                <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
                <div class="ui green ok inverted button" title="Haga clic para anular"> <i class="checkmark icon"></i>Anular</div>
            </div>
        </div>
    <!--end update modal -->


 
@stop

@section('scripts')
    <script src="{{ asset('js/venta/detalles.js') }}"></script>
@stop


