<?php


Route::get('/', function () { return redirect('/login'); });
Route::get('/login', 'Auth\LoginController@showLoginForm')->name('login');
Route::post('/loginme', 'Auth\LoginController@login')->name('loginme');
Route::post('/logout', 'Auth\LoginController@logout')->name('logout');

Route::get('/recovery', 'Auth\ForgotPasswordController@recovery')->name('recovery');
Route::post('/recoveryme', 'Auth\ForgotPasswordController@recoveryme')->name('recoveryme');

Route::get('/reset', 'Auth\ForgotPasswordController@reset')->name('reset');
Route::post('/resetme', 'Auth\ForgotPasswordController@resetme')->name('resetme');

Route::get('/password/{id}', 'Auth\ForgotPasswordController@password')->name('password');
Route::post('/passwordme', 'Auth\ForgotPasswordController@passwordme')->name('passwordme');

Route::get('/home', 'HomeController@index')->name('home');

Route::group(array('before' => 'auth', 'prefix' => 'home'),function() 
{
	Route::get('getVentas', 'HomeController@getVentas');
});

Route::group(array('before' => 'auth', 'prefix' => 'personal'),function() 
{
	Route::get('nuevo', 'UsuarioController@nuevo');
	Route::get('listar', 'UsuarioController@listar');
	Route::post('registrar', 'UsuarioController@registrar');
	Route::get('existeCampo', 'UsuarioController@existeCampo');
	Route::get('existeCampoEditar', 'UsuarioController@existeCampoEditar');
	Route::get('editar/{id}', 'UsuarioController@editar');
	Route::post('actualizar', 'UsuarioController@actualizar');
	Route::post('eliminar', 'UsuarioController@eliminar');
	Route::post('getById', 'UsuarioController@getById');
	Route::get('perfil/{username}', 'UsuarioController@perfil');
	Route::post('actualizarPassword', 'UsuarioController@actualizarPassword');
	Route::post('updateLocal', 'UsuarioController@updateLocal');
});


Route::group(array('before' => 'auth', 'prefix' => 'sucursal'),function() 
{
	Route::get('nuevo', 'LocalController@nuevo');
	Route::get('listar', 'LocalController@listar');
	Route::post('registrar', 'LocalController@registrar');
	Route::get('editar/{id}', 'LocalController@editar');
	Route::post('actualizar', 'LocalController@actualizar');
	Route::post('eliminar', 'LocalController@eliminar');
	Route::get('getAll', 'LocalController@getAll');
});

Route::group(array('before' => 'auth', 'prefix' => 'cliente'),function() 
{
	Route::post('registrar', 'ClienteController@registrar');
	Route::get('getByDocumento', 'ClienteController@getByDocumento');
	Route::get('getDniByApi', 'ClienteController@getDniByApi');
	Route::get('getRucByApi', 'ClienteController@getRucByApi');
	Route::get('getByNombre', 'ClienteController@getByNombre');
});

Route::group(array('before' => 'auth', 'prefix' => 'venta'),function() 
{
	Route::get('nuevo', 'VentaController@nuevo');
	Route::get('listar', 'VentaController@listar');
	Route::get('listar_anulados', 'VentaController@listar_anulados');
	Route::post('registrar', 'VentaController@registrar');
	Route::get('detalles/{id}', 'VentaController@detalles');
	Route::get('buscar', 'VentaController@buscar');
	Route::get('getCorrelativo', 'VentaController@getCorrelativo');
	Route::get('listar_deuda', 'VentaController@listar_deuda');
	Route::post('anular_deuda', 'VentaController@anular_deuda');
	Route::get('detalles_deuda/{id}', 'VentaController@detalles_deuda');
	Route::get('proforma_venta/{id}', 'VentaController@proforma_venta');
	Route::get('hospedar_venta/{id}', 'VentaController@hospedar_venta');
});

Route::group(array('before' => 'auth', 'prefix' => 'contingencia'),function() 
{
	Route::get('nuevo', 'ContingenciaController@nuevo');
	Route::get('listar', 'ContingenciaController@listar');
	Route::get('listar_anulados', 'ContingenciaController@listar_anulados');
	Route::post('registrar', 'ContingenciaController@registrar');
	Route::get('detalles/{id}', 'ContingenciaController@detalles');
	Route::get('buscar', 'ContingenciaController@buscar');
	Route::get('credito/{id}', 'ContingenciaController@nuevo_credito');
	Route::post('registrar_credito', 'ContingenciaController@registrar_credito');

});

Route::group(array('before' => 'auth', 'prefix' => 'empresa'),function() 
{
	Route::get('nuevo', 'EmpresaController@nuevo');
	Route::post('registrar', 'EmpresaController@registrar');
	Route::get('editar/{id}', 'EmpresaController@editar');
	Route::post('actualizar', 'EmpresaController@actualizar');
	Route::get('envios', 'EmpresaController@envios');
});

Route::group(array('before' => 'auth', 'prefix' => 'nota'),function() 
{
	Route::get('listar_credito', 'NotaController@listar_credito');
	Route::get('estado_credito/{id}', 'NotaController@estado_credito');
	Route::get('credito/{id}', 'NotaController@credito');
	Route::get('listar_debito', 'NotaController@listar_debito');
	Route::get('estado_debito/{id}', 'NotaController@estado_debito');
	Route::get('debito/{id}', 'NotaController@debito');
	Route::post('registrar_credito', 'NotaController@registrar_credito');
	Route::post('registrar_debito', 'NotaController@registrar_debito');
	Route::get('detalles/{id}', 'NotaController@detalles');
});

Route::group(array('before' => 'auth', 'prefix' => 'electronico'),function() 
{
	Route::get('listar_facturas', 'ElectronicoController@listar_facturas');
	Route::get('estado_facturas/{id}', 'ElectronicoController@estado_facturas');
	Route::get('detalles/{id}', 'ElectronicoController@detalles');
	Route::get('listar_boletas', 'ElectronicoController@listar_boletas');
	Route::get('estado_boletas/{id}', 'ElectronicoController@estado_boletas');
	Route::get('notas_credito', 'ElectronicoController@notas_credito');
	Route::get('notas_debito', 'ElectronicoController@notas_debito');
	Route::get('resumen_diario', 'ElectronicoController@resumen_diario');
});

Route::group(array('before' => 'auth', 'prefix' => 'resumen'),function() 
{
	Route::get('listar', 'ResumenController@listar');
	Route::get('detalles/{id}', 'ResumenController@detalles');
	Route::get('estado/{id}', 'ResumenController@estado');
	
});

Route::group(array('before' => 'auth', 'prefix' => 'xml'),function() 
{
	Route::get('crearLlaves', 'XmlController@crearLlaves');
	Route::get('crearComprobante/{id}', 'XmlController@crearComprobante');
	Route::get('crearNota/{id}', 'XmlController@crearNota');
	Route::get('enviarResumen', 'XmlController@enviarResumen');
	Route::get('enviarResumenNota', 'XmlController@enviarResumenNota');
	Route::get('ticketResumen', 'XmlController@ticketResumen');
	Route::get('enviarFacturas', 'XmlController@enviarFacturas');
	Route::get('enviarNotas', 'XmlController@enviarNotas');
	Route::get('reenviarResumen', 'XmlController@reenviarResumen');
	Route::get('reenviarNota', 'XmlController@reenviarNota');
	Route::get('reenviarFactura', 'XmlController@reenviarFactura');
	Route::get('cdrResumen', 'XmlController@cdrResumen');
	Route::get('cdrFactura', 'XmlController@cdrFactura');
	Route::get('cdrNota', 'XmlController@cdrNota');

});


Route::group(array('before' => 'auth', 'prefix' => 'reporte'),function() 
{
	Route::get('comprobantes', 'ReporteController@comprobantes');
	Route::get('ventas', 'ReporteController@ventas');
	Route::get('compras', 'ReporteController@compras');
	Route::get('egresos', 'ReporteController@egresos');
	Route::get('usuarios', 'ReporteController@usuarios');
	Route::get('detalles/{id}', 'ReporteController@detalles');
	Route::get('productos_vendidos', 'ReporteController@productos_vendidos');
	Route::get('productos_comprados', 'ReporteController@productos_comprados');
	Route::get('stock', 'ReporteController@stock');
	Route::get('guia', 'ReporteController@guia');
	Route::get('alojamiento', 'ReporteController@alojamiento');
	Route::get('actuales', 'ReporteController@actuales');
	Route::get('proformas', 'ReporteController@proformas');
});

Route::group(array('before' => 'auth', 'prefix' => 'egreso'),function() 
{
	Route::get('nuevo', 'EgresoController@nuevo');
	Route::get('listar', 'EgresoController@listar');
	Route::get('detalles/{id}', 'EgresoController@detalles');
	Route::post('registrar', 'EgresoController@registrar');
});

Route::group(array('before' => 'auth', 'prefix' => 'proforma'),function() 
{
	Route::get('nuevo', 'ProformaController@nuevo');
	Route::get('listar', 'ProformaController@listar');
	Route::get('detalles/{id}', 'ProformaController@detalles');
	Route::post('registrar', 'ProformaController@registrar');
	Route::get('buscar', 'ProformaController@buscar');
	Route::get('getProductosById', 'ProformaController@getProductosById');
});


Route::group(array('before' => 'auth', 'prefix' => 'habitacion'),function() 
{
	Route::get('nuevo', 'HabitacionController@nuevo');
	Route::get('existeCampo', 'HabitacionController@existeCampo');
	Route::get('existeCampoEditar', 'HabitacionController@existeCampoEditar');
	Route::get('listar', 'HabitacionController@listar');
	Route::get('editar/{id}', 'HabitacionController@editar');
	Route::post('registrar', 'HabitacionController@registrar');
	Route::post('actualizar', 'HabitacionController@actualizar');
	Route::get('buscar', 'HabitacionController@buscar');
	Route::post('getById', 'HabitacionController@getById');
	Route::post('eliminar', 'HabitacionController@eliminar');
	Route::get('estado/{id}', 'HabitacionController@estado');
	Route::post('activar', 'HabitacionController@activar');
	Route::post('mantener', 'HabitacionController@mantener');
});

Route::group(array('before' => 'auth', 'prefix' => 'huesped'),function() 
{
	Route::get('nuevo', 'HuespedController@nuevo');
	Route::get('existeCampo', 'HuespedController@existeCampo');
	Route::get('existeCampoEditar', 'HuespedController@existeCampoEditar');
	Route::get('listar', 'HuespedController@listar');
	Route::get('editar/{id}', 'HuespedController@editar');
	Route::post('registrar', 'HuespedController@registrar');
	Route::post('actualizar', 'HuespedController@actualizar');
	Route::get('buscar', 'HuespedController@buscar');
	Route::post('getById', 'HuespedController@getById');
	Route::post('getByDni', 'HuespedController@getByDni');
	Route::post('eliminar', 'HuespedController@eliminar');
});

Route::group(array('before' => 'auth', 'prefix' => 'hospedar'),function() 
{
	Route::get('nuevo/{id}', 'HospedarController@nuevo');
	Route::get('agregar/{id}', 'HospedarController@agregar');
	Route::get('transferir/{id}', 'HospedarController@transferir');
	Route::get('listar', 'HospedarController@listar');
	Route::get('ingreso', 'HospedarController@ingreso');
	Route::get('salida', 'HospedarController@salida');
	Route::get('detalles/{id}', 'HospedarController@detalles');
	Route::post('registrar', 'HospedarController@registrar');
	Route::post('registrar_agregar', 'HospedarController@registrar_agregar');
	Route::post('registrar_transferir', 'HospedarController@registrar_transferir');
	Route::post('registrar_reserva', 'HospedarController@registrar_reserva');
	Route::post('desocupar', 'HospedarController@desocupar');
});

Route::group(array('before' => 'auth', 'prefix' => 'reserva'),function() 
{
	Route::get('nuevo', 'ReservaController@nuevo');
	Route::get('listar', 'ReservaController@listar');
	Route::get('cancelados', 'ReservaController@cancelados');
	Route::get('detalles/{id}', 'ReservaController@detalles');
	Route::post('registrar', 'ReservaController@registrar');
	Route::post('cancelar', 'ReservaController@cancelar');
	Route::get('buscar', 'ReservaController@buscar');
	Route::get('ocupar/{id}', 'ReservaController@ocupar');
	Route::get('alertas', 'ReservaController@alertas');
});