<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">RETIRAR PRODUCTOS</h4>
            <br>

            <form class="ui form" id="frmNuevo" autocomplete="off">

                    <div class="three fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Ubicacion del producto</div>
                        </div>
                        <div class="nine wide field">
                            <select class="ui fluid small input dropdown" name="id_local">
                                 <option value="<?php echo e($local->id_local); ?>"> <?php echo e($local->nombre); ?> (<?php echo e(ucwords(mb_strtolower($local->direccion ))); ?>)</option>
                            </select>  
                        </div>
                    </div>
                    
                    <div class="three fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Producto a retirar</div>
                        </div>
                        <div class="nine wide field">
                            <select class="ui small search selection dropdown" name="id_producto">
                                <option value="">Buscar...</option>
                                <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                   <option value="<?php echo e($prod->id_producto); ?>" data-stock="<?php echo e($prod->stock); ?>" data-precio="<?php echo e($prod->producto->precio); ?>"><?php echo e($prod->producto->nombre); ?> <?php echo e($prod->producto->descripcion); ?> (<?php echo e($prod->producto->tipo_presentacion->nombre); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                            </select> 
                        </div>
                        <div class="two wide field">
                            <div class="ui fluid small green button btn_buscar_producto" title="Clic para buscar"><i class="search icon"></i>BUSCAR</div>
                        </div>
                    </div>

                    <div class="three fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Motivo de retiro</div>
                        </div>
                        <div class="nine wide field">
                            <div class="ui small input ">
                              <input type="text" name="motivo_retiro"  maxlength="200" oninput="$.upperCase(this)">
                            </div>
                        </div>
                    </div>
                    
                    <div class="four fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Stock actual</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui small input ">
                                <input type="text" id="stock" readonly>
                            </div>
                        </div>
                        <div class="three wide field">
                            <div class="ui fluid large white label">Precio de venta</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui labeled small input">
                                <label class="ui label">S/</label>
                                <input type="text" id="precio_venta" readonly>
                            </div> 
                        </div>
                    </div>

                    <div class="four fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Cantidad a retirar</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui small input ">
                                <input type="text" name="cantidad_retiro" id="cantidad_retiro" maxlength="5" value="1" onkeyup="calculaMontoPerdido()">
                            </div>
                        </div>
                        <div class="three wide field">
                            <div class="ui fluid large white label">Monto perdido</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui labeled small input">
                                <label class="ui label">S/</label>
                                <input type="text" name="monto_perdido" id="monto_perdido" maxlength="11">
                            </div> 
                        </div>
                    </div>

                    <div class="form_footer">
                        <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>REGISTRAR</div>
                    </div>

            </form>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="check circle icon"></i>Registrar Información</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea registrar esta información en el sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para registrar"> <i class="checkmark icon"></i>Registrar</div>
        </div>
    </div>
    <!--end register modal -->
    
    <!--start buscar producto modal -->
    <style>
        .mostar_tabla_producto{display:block;}
        .ocultar_tabla_producto{display:none;}
    </style>
    <div class="ui standard large modal" id="buscar_producto_modal">
        <div class="header">Buscar Productos</div>
        <div class="scrolling content">
            <div class="ui icon small input">
                <input type="text" id="buscar_producto" placeholder="Buscar productos..." onkeyup="buscarProducto(this)">
                <i class="search icon"></i>
            </div> 
            <table class="ui celled striped table" id="lista_productos">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Cod Barras</th>
                        <th class="head_table">Producto</th>
                        <th class="head_table">Presentacion</th>
                        <th class="head_table">U. Med</th>
                        <th class="head_table">Precio S/</th>
                        <th class="head_table">Vencimiento</th>
                        <th class="head_table">Stock</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = 1/**/ ?>
                    <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr data-table="<?php echo e($row->id_producto); ?>">
                        <td><?php echo e($i); ?></td>
                        <td><?php echo e($row->producto->codigo_barras); ?></td>
                        <td><?php echo e($row->producto->nombre); ?> <?php echo e($row->producto->descripcion); ?></td>
                        <td><?php echo e($row->producto->tipo_presentacion->nombre); ?></td>
                        <td><?php echo e($row->producto->unidad_medida->nombre); ?></td>
                        <td><?php echo e($row->producto->precio); ?></td>
                        <td><?php echo e(!is_null($row->producto->fecha_vencimiento) ? $row->producto->fecha_vencimiento : "Sin fecha"); ?></td>
                        <td><?php echo e(round($row->stock)); ?></td>
                        
                        <td>                            
                            <div class="ui mini vertical animated positive button btn_seleccionar_producto" title="Seleccionar este producto" data-id="<?php echo e($row->id_producto); ?>" data-stock="<?php echo e($row->stock); ?>" data-precio="<?php echo e($row->producto->precio); ?>">
                                <div class="hidden content">Elegir</div>
                                <div class="visible content"><i class="check icon"></i></div>
                            </div>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
        </div>
    </div>
    <!--end buscar producto modal -->
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/retiro/nuevo.js')); ?>"></script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>