<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            

            <div class="ui top attached tabular menu">
                <a class="red item active" data-tab="dos">Habitaciones Ocupadas <div class="ui circular red label"><?php echo e($ocupadas->count()); ?></div></a>
            </div>
            

            <!-- start tab 2 -->
            <div class="ui bottom attached tab active" data-tab="dos">
                <br><br>
                <div class="ui equal width grid">
                    <div class="row">
                         <div class="column">
                            <div class="ui action small input"  autocomplete="off">
                                <input type="text" id="buscar_habitacion_ocupadas" placeholder="Numero de habitacion">
                                <div class="ui icon button" id="btn_buscar_habitacion_ocupadas" title="Clic para buscar"><i class="search icon"></i></div>
                            </div> 
                        </div>
                        <div class="column export_files" style="text-align: right">
                            <select class="ui small input dropdown" id="tipo_habitacion_ocupadas">
                                <option value="">Seleccione</option>
                                <option value="TODOS">Todos</option>
                                <?php $__currentLoopData = $tipo_habitacion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tipo->nombre); ?>"> <?php echo e(ucwords(mb_strtolower($tipo->nombre))); ?> </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>  
                        </div>
                    </div>
                </div>
                <table class="ui celled striped table" id="tabla_ocupadas">
                    <thead>
                        <tr>
                            <th class="head_table">Numero</th>
                            <th class="head_table">Tipo</th>
                            <th class="head_table">Fecha de Ingreso</th>
                            <th class="head_table">Estado</th>
                            <th class="head_table">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $ocupadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr data-table="<?php echo e($data->id_hospedar); ?>">
                            <td><div class="ui violet label"><?php echo e($data->habitacion->numero); ?></div></td>
                            <td><?php echo e($data->habitacion->tipo_habitacion->nombre); ?></td>
                            <td><?php echo e(date('d-m-Y g:i A', strtotime($data->fecha_ingreso))); ?></td>
                            <td>
                                <div class="ui red label"><?php echo e($data->habitacion->situacion); ?></div>
                            </td>
                            <td>                         
                                <a class="ui mini vertical blue button" title="Ver informacion detallada" href="<?php echo e(url('hospedar/detalles/'.$data->id_hospedar)); ?>">
                                    <div class="visible content"><i class="search icon"></i> Ver Detalles</div>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table> 
            </div>
            <!-- end tab 2 -->

        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/hospedar/listar.js')); ?>"></script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>