<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE COMPROBANTE ELECTRONICO</h4>
            
            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que registró la venta :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column"><?php echo e(ucwords(mb_strtolower($data->usuario->nombres))); ?> <?php echo e(ucwords(mb_strtolower($data->usuario->apellidos))); ?> (<?php echo e($data->usuario->username); ?>)</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se registró la venta :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column"><?php echo e(ucwords(mb_strtolower($data->created_at))); ?></div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet  five wide computer column message_header">Tienda donde se realizó la venta:</div>
                        <div class="sixteen wide mobile eight wide tablet  eleven wide computer column"><?php echo e(ucwords(mb_strtolower($data->local->nombre))); ?> (<?php echo e(ucwords(mb_strtolower($data->local->direccion))); ?>)</div>
                    </div>
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Nombre de Cliente :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column"><a href="<?php echo e(url('cliente/editar/'.$data->id_cliente)); ?>" title="Clic para ver informacion"><?php echo e(ucwords(mb_strtolower($data->cliente->nombre))); ?> (<?php echo e($data->cliente->tipo_documento->nombre); ?> : <?php echo e($data->cliente->numero_documento); ?>)</a></div>
                    </div>
                     <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  three wide computer column message_header">Direccion de Cliente:</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column"><?php echo e(ucwords(mb_strtolower($data->cliente->direccion))); ?></div>
                    </div>
                </div>
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Tipo de Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><?php echo e($data->tipo_comprobante->nombre); ?></div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">N° Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><a href="<?php echo e(url('venta/detalles/'.$data->id_venta)); ?>"><?php echo e($data->nombre_comprobante); ?></a></div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Venta :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><?php echo e($data->fecha_venta); ?></div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Monto Total de la Venta :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ <?php echo e($data->total_venta); ?></div>
                    </div>
                    <?php if($data->estado_envio == "REGISTRADO"): ?>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Mensaje de envio a SUNAT :</div>
                        <div class="sixteen wide mobile eight wide tablet  twelve wide computer column">PENDIENTE - El comprobante se encuentra pendiente de envio a la SUNAT</div>                    
                    </div>
                    <?php else: ?>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Mensaje de envio a SUNAT :</div>
                        <div class="sixteen wide mobile eight wide tablet  twelve wide computer column"><?php echo e(($data->estado_envio)); ?> - <?php echo e($data->mensaje_envio); ?></div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Envio:</div>
                        <div class="sixteen wide mobile eight wide tablet  twelve wide computer column"><?php echo e(($data->updated_at)); ?></div>
                    </div>
                    <?php endif; ?>

                </div>
            </div>
            
            <?php if($data->id_nota != null): ?>
                <div class="ui error message">
                    <div class="ui equal width grid">
                        <div class="row" style="padding-bottom: 0px !important">
                            <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Estado actual del comprobante :</div>
                            <div class="sixteen wide mobile eight wide tablet  twelve wide computer column" style="color: red!important">El comprobante fue ANULADO  con Nota de Credito <a style="text-decoration: underline;" href="<?php echo e(url('nota/detalles/'.$data->id_nota)); ?>">(ver detalles)</a></div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Producto</th>
                        <th class="center aligned" data-tooltip="Unidad de Medida" data-position="top center" data-inverted="">U. Med.</th>
                        <th class="center aligned" data-tooltip="Cantidad vendida" data-position="top center" data-inverted="">Cant.</th>
                        <th class="center aligned" data-tooltip="Precio de venta" data-position="top center" data-inverted="">Precio S/</th>
                        <th class="center aligned" data-tooltip="Monto de Descuento" data-position="top center" data-inverted="">Dscto S/</th>
                        <th class="center aligned">Subtotal</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    <?php $__currentLoopData = $detalle_venta; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr data-table="<?php echo e($venta->id_detalle_venta); ?>">
                        <td><a href="<?php echo e(url('producto/editar/'.$venta->id_producto)); ?>" title="Clic para ver informacion"><?php echo e(ucwords(mb_strtolower($venta->producto->nombre))); ?> (<?php echo e($venta->producto->tipo_presentacion->nombre); ?>)</a></td>
                        <td><?php echo e($venta->producto->unidad_medida->nombre); ?></td>
                        <td><?php echo e($venta->cantidad); ?></td>
                        <td><?php echo e($venta->precio_venta); ?></td>
                        <td><?php echo e($venta->descuento==0 ? $venta->descuento : '-'.$venta->descuento); ?></td>
                        <td class="warning"><?php echo e($venta->precio_venta_total); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="<?php echo e(URL::previous()); ?>"><i class="arrow left icon"></i>REGRESAR</a>
                <?php if($data->estado_envio == "NO ENVIADO" && $data->id_tipo_comprobante == 1): ?>
                <div class="ui small right floated red button btn_reenviar" data-id="<?php echo e($data->id_venta); ?>"><i class="sync alternate icon"></i>Reenviar</div>
                <?php endif; ?>
                <?php if( ($data->estado_envio == "ACEPTADO" && $data->id_tipo_comprobante == 1) || $data->estado_envio == "RECHAZADO"): ?>
                <a class="ui small right floated primary button btn_cdr" href="<?php echo e(url('../sunat/cdr/comprobantes/R-'.$empresa->ruc.'-'.$data->tipo_comprobante->codigo.'-'.$data->nombre_comprobante.'.xml')); ?>" target="_blank"><i class="download icon"></i>Descargar CDR</a>
                <?php endif; ?>
                <a class="ui small right floated green button btn_cdr" href="<?php echo e(url('../sunat/xml/comprobantes/'.$empresa->ruc.'-'.$data->tipo_comprobante->codigo.'-'.$data->nombre_comprobante.'.xml')); ?>" target="_blank"><i class="download icon"></i>Descargar XML</a>
            </div>  

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/electronico/detalles.js')); ?>"></script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>