
<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">EMITIR COMPROBANTE DE LA HABITACION <div class="ui violet label"><?php echo e($hospedar->habitacion->numero); ?></div></h4>
            
            <form class="ui form" id="frmNuevo" autocomplete="off"> 
                
                <div class="inline four fields">

                    <input type="hidden" name="id_hospedar" value="<?php echo e($hospedar->id_hospedar); ?>">

                    <div class="ten wide field"></div>

                    <div class="field datos_comprobante" >
                        <input type="hidden" id="tipo_comprobante" name="id_tipo_comprobante" value="1">
                        <input type="hidden" id="tipo_documento" name="id_tipo_documento" value="1">

                        <div class="ui fluid tiny black button pointing dropdown item" id="select_comprobante_venta">
                            <span class="text">FACTURA</span><i class="dropdown icon"></i>
                            <div class="menu border_shadow">
                                <?php $__currentLoopData = $tipo_comprobante; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="item" data-value="<?php echo e($data->id_tipo_comprobante); ?>"><?php echo e($data->nombre); ?></div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                            </div>
                        </div>
  
                        <div class="ui large white label" id="serie_comprobante"><?php echo e($serie); ?></div>-
                        <div class="ui large white label" id="numero_comprobante"><?php echo e($numero); ?></div>             
                    </div>
                    <div class="two wide field"></div>
                </div>
                <br>

                <div class="four fields">
                    <div class="three wide field">
                        <div class="ui fluid large white label" id="tipo_doc">RUC</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui action small input" >
                              <input type="text" id="numero_documento" name="numero_documento" maxlength="11" value="<?php echo e($juridico ? $juridico->numero_documento : ''); ?>">
                              <div class="ui icon button" id="loading_doc" title="Clic para buscar"><i class="search icon"></i></div>
                        </div>
                    </div>
                </div>

                <div class="three fields">
                    <div class="three wide field">
                        <div class="ui fluid large white label" id="nomb">Razon Social</div>
                    </div>
                    <div class="eleven wide field">
                        <div class="ui small input">
                            <input type="text" id="nombre_cliente" name="nombre" maxlength="200" oninput="$.upperCase(this)" value="<?php echo e($juridico ? $juridico->nombre : $detalles->huesped->razon_social); ?>">
                        </div>  
                    </div>
                </div>

                <div class="five fields">
                    <div class="three wide field">
                        <div class="ui fluid large white label">Direccion</div>
                    </div>
                    <div class="eleven wide field">
                        <div class="ui small input" id="dir_dis">
                            <input type="text" name="direccion" id="direccion" maxlength="100" oninput="$.upperCase(this)" value="<?php echo e($detalles->huesped->direccion_empresa); ?>">
                        </div>  
                    </div>
                </div>

                

                <div class="five fields" >
                    <div class="three wide field">
                        <div class="ui fluid large white label">Fecha de Emision</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input">
                            <input type="text" class="fecha hasDate" name="fecha_venta" >
                        </div> 
                    </div>
                    <div class="two wide field">
                        <div class="ui fluid large white label">Tipo de Pago</div>
                    </div>
                    <div class="three wide field">
                        <select class="ui fluid small input dropdown" name="tipo_pago">
                            <option value="EFECTIVO">Pago en Efectivo</option>
                            <option value="TARJETA">Pago con Tarjeta</option>
                            <option value="CREDITO">Pago al Credito</option>
                        </select> 
                    </div>
                    <div class="three wide field" id="fecha_pago" style="visibility: hidden;">
                        <div class="ui small input">
                            <input type="text" class="fecha_fut" name="fecha_pago" placeholder="Fecha a cobrar">
                        </div> 
                    </div>
                </div>
               
                <br>
                <br>
                    
                <table class="ui celled table">
                    <thead>
                        <tr>
                            <th class="center aligned">Cantidad</th>
                            <th class="center aligned">Concepto</th>
                            <th class="center aligned" data-tooltip="Monto a facturar" data-position="top center" data-inverted="">Monto S/</th>
                            
                            <th class="center aligned">Subtotal S/</th>
                            <th class="center aligned">Accin</th>
                        </tr>
                    </thead>
                    <tbody id="tbody">

                        <tr class="rows" id="1">
                            <td><input type="text" name="cantidad[]" class="cant 1" id="cant1" value="1" size="1"></td>
                            <td><input type="text" name="descripcion[]" value="SERVICIO POR NOCHE(S) DE ALOJAMIENTO" /></td>
                            <td class="warning"><input type="text" class="prec 1" name="precio_venta[]" id="prec1" size="2"/></td>
                            <td style="display:none"><input type="hidden" name="descuento[]" class="desc 1" id="desc1" value="0.00" size="1"></td>
                            <td style="display:none"><input type="hidden" name="impuesto[]" class="impu 1" id="impu1"/></td>
                            <td class="positive"><input type="hidden" name="subtotal[]" id="subt1" /><span id="v_subt1"></span></td>
                            <td><div class="ui mini vertical animated red button" onclick="quitarTabla(this)" title="Quitar de la lista"><div class="hidden content">Quitar</div><div class="visible content"><i class="times icon"></i></div></div></td>
                        </tr>


                    </tbody>
                </table>

                <div class="form_footer">
                    <div class="ui labeled small input">
                        <label class="ui brown label">TOTAL  S/</label>
                        <input type="text" name="total_venta" id="total_venta" size="5" readonly style="width: 0%">
                    </div> 
                    &nbsp;&nbsp;
                    <a href="#" class="btn_nuevo_concepto">(+) Agregar nuevo concepto</a>
                    <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>EMITIR COMPROBANTE</div>
                </div>

            </form>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="circular inverted white dollar sign icon"></i>Emitir Comprobante</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>07Desea emitir el comprobante para esta habitacion?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para emitir"> <i class="checkmark icon"></i>Emitir</div>
        </div>
    </div>
    <!--end register modal -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/hospedar/venta.js')); ?>"></script>

    <script type="text/javascript">
        var valor_impuesto = '<?php echo $empresa->valor_impuesto; ?>';

        var nombre = '<?php echo $natural ? $natural->nombre : $detalles->huesped->nombre; ?>';
        var dni = '<?php echo $natural ? $natural->numero_documento : $detalles->huesped->dni; ?>';
        var razon_social = '<?php echo $juridico ? $juridico->nombre : $detalles->huesped->razon_social; ?>';
        var ruc = '<?php echo $juridico ? $juridico->numero_documento : ''; ?>';


        $(function () {
            var fecha_ingreso = '<?php echo $hospedar->fecha_ingreso; ?>';
            var precio = '<?php echo $hospedar->habitacion->precio; ?>';
            var fecha_actual = '<?php echo $fecha_actual; ?>';

            resta = restaFechas(fecha_ingreso, fecha_actual);

            if (resta.dif_dias > 0){ 
                $('#prec1').val((parseFloat(precio*resta.dif_dias)).toFixed(2));  
                $('#subt1').val((parseFloat(precio*resta.dif_dias)).toFixed(2)); 
                $('#impu1').val((parseFloat(precio*resta.dif_dias)-(parseFloat(precio*resta.dif_dias)/(1+(valor_impuesto/100)))).toFixed(2)); 
                $('#v_subt1').html((parseFloat(precio*resta.dif_dias)).toFixed(2)); 
            }
            else {
                $('#prec1').val(parseFloat(precio).toFixed(2)); 
                $('#subt1').val(parseFloat(precio).toFixed(2)); 
                $('#impu1').val((parseFloat(precio)-(parseFloat(precio)/(1+(valor_impuesto/100)))).toFixed(2)); 
                $('#v_subt1').html(parseFloat(precio).toFixed(2)); 
            }
            calcularTotal();

            $('#tipo_doc').bind("DOMSubtreeModified",function(){
                if ($("#tipo_doc").text() == 'RUC') {
                    $("#nombre_cliente").val(razon_social);
                    $("#numero_documento").val(ruc);
                }
                if ($("#tipo_doc").text() == 'DNI') {
                    $("#nombre_cliente").val(nombre);
                    $("#numero_documento").val(dni);
                }
            });
        })

    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>