<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">COMPRAR PRODUCTOS PARA ALMACÉN</h4>
            <br>

            <form class="ui form" id="frmNuevo" autocomplete="off"> 
                
                <!-- start tab 1 -->
                <div class="ui tab active" data-tab="one">

                    <div class="three fields">
                        <div class="three wide field">
                            <div class="ui fluid large white label">Almacén de Destino</div>
                        </div>
                        <div class="eleven wide field">
                            <select class="ui fluid small input dropdown" name="id_local">
                                <option value="">Seleccione</option>
                                <?php if(Auth::guard("usuario")->user()->id_rol == 1): ?>
                                    <?php $__currentLoopData = $locales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $local): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                       <option value="<?php echo e($local->id_local); ?>"> <?php echo e($local->nombre); ?> (<?php echo e(ucwords(mb_strtolower($local->direccion ))); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                     <option value="<?php echo e(Auth::guard("usuario")->user()->id_local); ?>"> <?php echo e(Auth::guard('usuario')->user()->local->nombre); ?> (<?php echo e(ucwords(mb_strtolower(Auth::guard('usuario')->user()->local->direccion ))); ?>)</option>
                                <?php endif; ?>     
                            </select>  
                        </div>
                    </div>

                    <div class="three fields">
                        <div class="three wide field">
                            <div class="ui fluid large white label">Proveedor</div>
                        </div>
                        <div class="eleven wide field">
                            <select class="ui small search selection dropdown" name="id_proveedor">
                            <option value="">Seleccione</option>
                            <?php $__currentLoopData = $proveedores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                               <option value="<?php echo e($data->id_proveedor); ?>"> <?php echo e($data->nombre); ?> (<?php echo e(ucwords(mb_strtolower($data->numero_documento ))); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                        </select> 
                        </div>
                        <div class="two wide field">
                            <div class="ui fluid small green button btn_nuevo_proveedor" title="Clic para agregar nuevo"><i class="plus icon"></i>NUEVO</div>
                        </div>
                    </div>

                    <div class="four fields">
                        <div class="three wide field">
                            <div class="ui fluid large white label">Tipo Comprobante</div>
                        </div>
                        <div class="field">
                            <select class="ui fluid small input dropdown" name="tipo_comprobante">
                                <option value="">Seleccione</option>
                                <option value="Factura">Factura</option>
                                <option value="Boleta">Boleta</option>
                                <option value="Recibo">Recibo</option>
                            </select> 
                        </div>
                        <div class="three wide field">
                            <div class="ui fluid large white label">Fecha de Compra</div>
                        </div>
                        <div class="field">
                            <div class="ui small input">
                                <input type="text" class="fecha" name="fecha_compra" >
                            </div> 
                        </div>
                    </div>

                    <div class="five fields">
                        <div class="three wide field">
                            <div class="ui fluid large white label">N° Comprobante</div>
                        </div>
                        <div class="four wide field">
                            <div class="ui small input">
                                <input type="text" placeholder="F001-001" name="numero_comprobante" oninput="$.upperCase(this)">
                            </div> 
                        </div>
                        <div class="three wide field">
                            <div class="ui fluid large white label">Tipo de Compra</div>
                        </div>
                        <div class="four wide field">
                            <select class="ui fluid small input dropdown" name="tipo_compra">
                                <option value="CONTADO">Al Contado</option>
                                <option value="CREDITO">Al Crédito</option>
                            </select> 
                        </div>
                        <div class="two wide field" id="fecha_pago" style="visibility: hidden;">
                            <div class="ui small input">
                                <input type="text" class="fecha_fut" name="fecha_pago" placeholder="Fecha Pago">
                            </div> 
                        </div>
                    </div>

                    <div class="form_footer">
                        <div class="ui right floated default button tab_two">SIGUIENTE<i class="arrow right icon"></i></div>
                    </div>
                </div>
                <!-- end tab 1 -->

                <!-- start tab 2 -->
                <div class="ui tab" data-tab="two">
                    
                    <div class="three fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Nombre del Producto</div>
                        </div>
                        <div class="seven wide field">
                            <select class="ui small search selection dropdown" name="id_prod">
                                <option value="">Seleccione</option>
                                <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                   <option value="<?php echo e($data->id_producto); ?>"  data-precio="<?php echo e($data->precio); ?>"><?php echo e($data->nombre); ?> <?php echo e($data->descripcion); ?> (<?php echo e($data->tipo_presentacion->nombre); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                            </select> 
                        </div>
                        <div class="three wide field">
                        <div class="ui icon small input" id="loading_input">
                            <input type="text" id="cod_barras" maxlength="100" placeholder="CODIGO DE BARRAS" onkeyup="$.buscarCodigoBarras()">
                            <i class="search icon"></i>
                        </div> 
                    </div> 
                        <div class="two wide field">
                            <div class="ui fluid small green button btn_nuevo_producto" title="Clic para agregar nuevo"><i class="plus icon"></i>NUEVO</div>
                        </div>
                    </div>

                    <div class="four fields">

                        <div class="four wide field">
                            <div class="ui fluid large white label">Precio de Venta Unitario</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui labeled small input">
                                <label class="ui label">S/</label>
                                <input type="text" name="precio_venta_unit" id="precio_venta_unit" maxlength="11" onkeyup="calculaUtilidad()">
                            </div> 
                        </div>
                    </div>
                    <div class="four fields">


                        <div class="four wide field">
                            <div class="ui fluid large white label">Cantidad Comprada</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui small input">
                                <input type="text" name="cant" id="cant" maxlength="8" onkeyup="calculaPrecioCompra()">
                            </div> 
                        </div>

                        <div class="four wide field">
                            <div class="ui fluid large white label">Precio de Compra Unitario</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui labeled small input">
                                <label class="ui label">S/</label>
                                <input type="text" id="precio_compra_unitario" readonly maxlength="11">
                            </div> 
                        </div>

                    </div>

                    <div class="four fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Precio de Compra Total</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui labeled small input">
                                <label class="ui label">S/</label>
                                <input type="text" name="precio_compra_tot" id="precio_compra_tot" maxlength="11" onkeyup="calculaPrecioCompra()">
                            </div> 
                        </div>
                        <div class="four wide field">
                            <div class="ui fluid large white label">Ganancia por Unidad</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui labeled small input">
                                <label class="ui label">S/</label>
                                <input type="text" id="utilidad" readonly maxlength="11">
                            </div> 
                        </div> 
                    </div>

            

                    <div class="ui hidden divider"></div>
                    <div class="form_footer">
                        <div class="ui left floated default button tab_one"><i class="arrow left icon"></i>REGRESAR</div>
                        <div class="ui right floated teal button btn_agregar_producto"><i class="arrow down icon"></i>AÑADIR A LISTA</div>
                    </div>

                    <div class="ui divider"></div>

                    <table class="ui celled table">
                        <thead>
                            <tr>
                                <th class="center aligned">Producto</th>
                                <th class="center aligned" data-tooltip="Cantidad comprada" data-position="top center" data-inverted="">Cant.</th>
                                <th class="center aligned" data-tooltip="Precio de compra" data-position="top center" data-inverted="">P. Compra</th>
                                <th class="center aligned">Subtotal</th>
                                <th class="center aligned" data-tooltip="Precio de venta" data-position="top center" data-inverted="">P. Venta</th>
                                <th class="center aligned">Ganancia</th>
                                <th class="center aligned">Acción</th>
                            </tr>
                        </thead>
                        <tbody id="tbody"></tbody>
                    </table>

                    <div class="form_footer">
                        <div class="ui disabled labeled small input">
                            <label class="ui label">TOTAL</label>
                            <input type="text" name="total_compra" id="total_compra" size="4" style="width: 0%">
                        </div> 
                        
                        <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>REGISTRAR COMPRA</div>
                    </div>
                </div>
                <div id="inputs"></div>
                <!-- end tab 2 -->
            </form>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="shopping cart icon"></i>Registrar Productos</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea registrar estos productos en el sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para registrar"> <i class="checkmark icon"></i>Registrar</div>
        </div>
    </div>
    <!--end register modal -->

    <!--start nuevo proveedor modal -->
    <div class="ui standard small modal" id="nuevo_proveedor_modal">
        <div class="header">Registrar Nuevo Proveedor</div>
        <div class="content">
            <div class="ui disabled inverted dimmer" id="loader_proveedor">
                <div class="ui text loader">Procesando...</div>
            </div>
            <form class="ui form" id="frmNevoProveedor" autocomplete="off">
                <div class="field">
                    <div class="field">
                        <label>Nombre / Razon Social</label>
                        <div class="ui small input ">
                          <input type="text" name="nombre" maxlength="200" oninput="$.upperCase(this)">
                        </div>
                    </div>
                </div>
                
                <div class="two fields">
                    <div class="field">
                        <label>Tipo de Documento</label>
                        <select class="ui small input dropdown" name="id_tipo_documento">
                            <option value="">Seleccione</option>
                             <?php $__currentLoopData = $tipo_documento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($tipo->id_tipo_documento); ?>"><?php echo e($tipo->nombre); ?></option>
                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>  
                    </div>
                    <div class="field">
                        <label>Numero de Documento</label>
                        <div class="ui small input ">
                          <input type="text" name="numero_documento" maxlength="11">
                        </div>
                    </div>
                </div> 

                <div class="two fields">
                    <div class="field">
                        <label>Direccion</label>
                        <div class="ui small input ">
                          <input type="text" name="direccion" maxlength="100" oninput="$.upperCase(this)">
                        </div>
                    </div>
                    <div class="field">
                        <label>Telefono</label>
                        <div class="ui small input ">
                          <input type="text" name="telefono"  maxlength="15">
                        </div>
                    </div>
                </div>
                <div class="two fields">
                    <div class="field">
                        <label>Email</label>
                        <div class="ui small input ">
                          <input type="text" name="email" maxlength="50">
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
            <div class="ui right floated primary button btn_registrar_proveedor"><i class="check icon"></i>REGISTRAR</div>
        </div>
    </div>
    <!--end nuevo proveedor  modal -->

    <!--start nuevo producto modal -->
    <div class="ui modal" id="nuevo_producto_modal">
        <div class="header">Registrar Nuevo Producto</div>     
        <div class="scrolling content">
            <div class="ui disabled inverted dimmer" id="loader_producto">
                <div class="ui text loader">Procesando...</div>
            </div>
            <form class="ui form" id="frmNuevoProducto" autocomplete="off">

                <div class="field">
                    <div class="field">
                        <label>Nombre del producto</label>
                        <div class="ui small input ">
                          <input type="text" name="nombre"  maxlength="200" oninput="$.upperCase(this)">
                        </div>
                    </div>
                </div> 
                
                <div class="two fields">
                    <div class="field">
                        <label>Marca del producto</label>
                        <div class="ui small input ">
                          <input type="text" name="descripcion" maxlength="100" oninput="$.upperCase(this)">
                        </div>
                    </div>
                    <div class="field">
                        <label>Código de Barras</label>
                        <div class="ui small input ">
                          <input type="text" name="codigo_barras"  maxlength="100" oninput="$.upperCase(this)">
                        </div>
                    </div>
                </div>

                <div class="two fields">
                    <div class="field">
                        <label>Tipo de Producto</label>
                        <select class="ui small input dropdown" name="tipo_producto">
                            <option value="Generico">Generico</option>
                            <option value="Comercial">Comercial</option>
                        </select>  
                    </div>
                    <div class="field">
                        <label>Fecha de Vencimiento</label>
                        <div class="ui small input">
                            <input type="text" class="fecha_fut" name="fecha_vencimiento">
                        </div>  
                    </div>
                </div> 

                <div class="two fields">
                    <div class="field">
                        <label>Tipo de Presentación</label>
                        <select class="ui small search selection dropdown" name="id_tipo_presentacion">
                            <?php $__currentLoopData = $tipo_presentacion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($tipo->id_tipo_presentacion); ?>"> <?php echo e($tipo->nombre); ?> </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>  
                    </div>
                    <div class="field">
                        <label>Unidad de Medida</label>
                        <select class="ui small search selection dropdown" name="id_unidad_medida">
                            <?php $__currentLoopData = $unidad_medida; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unidad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($unidad->id_unidad_medida); ?>"><?php echo e($unidad->nombre); ?> (<?php echo e($unidad->abreviatura); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>  
                    </div>
                </div>

                <div class="two fields">
                    <div class="field">
                        <label>Situacion de Impuesto</label>
                        <select class="ui small selection dropdown" name="situacion_impuesto">
                            <option value="AFECTO">Afecto</option>
                            <option value="INAFECTO">Inafecto</option>
                            <option value="EXONERADO">Exonerado</option>
                        </select>  
                    </div>
                    <div class="field">
                        <label>Precio de Venta Unitario</label>
                        <div class="ui labeled small input">
                            <label class="ui label">S/</label>
                            <input type="text" name="precio" maxlength="11">
                        </div>  
                    </div>
                </div> 

                <div class="two fields">
                     <div class="field">
                        <label>Tipo de Impuesto</label>
                        <select class="ui small selection dropdown" name="tipo_impuesto">
                            <option value="IGV">IGV</option>
                            <option value="ISC">ISC</option>
                        </select>  
                    </div>
                    <div class="field">
                        <label>Valor de Impuesto</label>
                        <div class="ui right labeled small input">
                            <input type="text" name="valor_impuesto" id="valor_impuesto" value="18" maxlength="8">
                            <label class="ui label">%</label>
                        </div>  
                    </div>
                </div>   
            </form>
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
            <div class="ui right floated primary button btn_registrar_producto"><i class="check icon"></i>REGISTRAR</div>
        </div>
    </div>
    <!--end nuevo producto  modal --> 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/compra/nuevo.js')); ?>"></script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>