
<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet thirteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REGISTRAR NUEVA RESERVA</h4>
            <br>

            <form class="ui form" id="frmNuevo" autocomplete="off">
               
                <div class="four fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Seleccione la Habitacion</div>
                    </div>
                    <div class="six wide field">
                        <select class="ui small search selection dropdown" name="id_habitacion">
                            <option value="">Seleccione...</option>
                            <?php $__currentLoopData = $habitaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                               <option value="<?php echo e($data->id_habitacion); ?>"><?php echo e($data->numero); ?> - <?php echo e($data->tipo_habitacion->nombre); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                        </select> 
                    </div>
                    
                    <div class="four wide field">
                        <div class="ui fluid small green button btn_buscar_habitacion" title="Clic para ver lista de habitaciones"><i class="search icon"></i>Buscar Habitacion</div>
                    </div>
                </div>

                <div class="three fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Nombre del Visitante</div>
                    </div>
                    <div class="ten wide field">
                        <div class="ui small input ">
                          <input type="text" name="nombre" maxlength="100" oninput="$.upperCase(this)">
                        </div>
                    </div>
                </div>

                <div class="five fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Documento de Identidad</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input ">
                          <input type="text" name="dni" maxlength="15" placeholder="N° DNI" oninput="$.upperCase(this)">
                        </div>
                    </div>
                    <div class="three wide field">
                        <div class="ui fluid large white label">Telefono</div>
                    </div>
                    <div class="four wide field">
                        <div class="ui small input ">
                          <input type="text" name="telefono" maxlength="20"  oninput="$.upperCase(this)">
                        </div>
                    </div>
                </div>

                <div class="five fields">
                   <div class="four wide field">
                        <div class="ui fluid large white label">Fecha de Llegada</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input">
                            <input type="text" class="fecha_fut_hora  hasDate" name="fecha_llegada" >
                        </div> 
                    </div>

                    <div class="three wide field">
                        <div class="ui fluid large white label">Medio de Reserva</div>
                    </div>
                    <div class="four wide field">
                        <select class="ui small search selection dropdown" name="medio">
                            <option value="">Seleccione...</option>
                            <option value="TELEFONICAMENTE">Via Telefonica</option>
                            <option value="PERSONALMENTE">Se acerco personalmente</option>
                            <option value="RESERVA POR PAGINA WEB">Mediante Pagina Web</option>
                            <option value="MEDIANTE OTROS MEDIOS">Por Otros Medios</option>
                        </select> 
                    </div>

                    
                </div>



                <div class="form_footer">
                    <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>REGISTRAR</div>
                </div>  


            </form>

        </div>
    </div>
    
    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="check circle icon"></i>Registrar Información</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea registrar esta información en el sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para registrar"> <i class="checkmark icon"></i>Registrar</div>
        </div>
    </div>
    <!--end register modal -->

        <!--start buscar producto modal -->
    <div class="ui standard large modal" id="buscar_habitacion_modal">
        <div class="header">Buscar Habitacion</div>
        <div class="scrolling content">
            <div class="ui disabled inverted dimmer" id="loader_busqueda">
                <div class="ui text loader">Procesando...</div>
            </div>

            <div class="ui action small input"  autocomplete="off">
                <input type="text" id="buscar_habitacion_disponibles" placeholder="Numero de habitacion">
                <div class="ui icon button" id="btn_buscar_habitacion_disponibles" title="Clic para buscar"><i class="search icon"></i></div>
            </div>


            <table class="ui celled striped table" id="tabla_disponibles">
                <thead>
                    <tr>
                        <th class="head_table">Numero</th>
                        <th class="head_table">Tipo</th>
                        <th class="head_table">Precio S/</th>
                        <th class="head_table">Estado</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody id="tbody_productos">
                    <?php $__currentLoopData = $habitaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $habitacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr data-table="<?php echo e($habitacion->id_habitacion); ?>">
                            <td><div class="ui violet label"><?php echo e($habitacion->numero); ?></div></td>
                            <td><?php echo e($habitacion->tipo_habitacion->nombre); ?></td>
                            <td><?php echo e($habitacion->precio); ?></td>
                            <td>
                                <?php if($habitacion->situacion == "DISPONIBLE"): ?>
                                <div class="ui green label"><?php echo e($habitacion->situacion); ?></div>
                                <?php elseif($habitacion->situacion == "OCUPADO"): ?>
                                <div class="ui red label"><?php echo e($habitacion->situacion); ?></div>
                                <?php elseif($habitacion->situacion == "MANTENIMIENTO"): ?>
                                <div class="ui yellow label"><?php echo e($habitacion->situacion); ?></div>
                                <?php endif; ?>
                                
                            </td>
                            <td>                         
                                <div class="ui mini vertical animated blue button btn_seleccionar_habitacion" title="Seleccionar esta habitacion" data-id="<?php echo e($habitacion->id_habitacion); ?>">
                                    <div class="hidden content">Elegir</div>
                                    <div class="visible content"><i class="check icon"></i></div>
                                </div>
                            </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
        </div>
    </div>
    <!--end buscar producto modal -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/reserva/nuevo.js')); ?>"></script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>