<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            

            <div class="ui top attached tabular menu">
                <a class="yellow item active" data-tab="tres">Habitaciones en Mantenimento <div class="ui circular yellow label"><?php echo e($mantenimiento->count()); ?></div></a>
                <a class="green item" data-tab="uno">Habitaciones Disponibles <div class="ui circular green label"><?php echo e($disponibles->count()); ?></div></a>
                
            </div>

            <!-- start tab 1 -->
            <div class="ui bottom attached tab active" data-tab="tres">
                <br><br>
                <div class="ui equal width grid">
                    <div class="row">
                         <div class="column">
                            <div class="ui action small input"  autocomplete="off">
                                <input type="text" id="buscar_habitacion_mantenimiento" placeholder="Numero de habitacion">
                                <div class="ui icon button" id="btn_buscar_habitacion_mantenimiento" title="Clic para buscar"><i class="search icon"></i></div>
                            </div> 
                        </div>
                        <div class="column export_files" style="text-align: right">
                            <select class="ui small input dropdown" id="tipo_habitacion_mantenimiento">
                                <option value="">Seleccione</option>
                                <option value="TODOS">Todos</option>
                                <?php $__currentLoopData = $tipo_habitacion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tipo->nombre); ?>"> <?php echo e(ucwords(mb_strtolower($tipo->nombre))); ?> </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>  
                        </div>
                    </div>
                </div>
                <table class="ui celled striped table" id="tabla_mantenimiento">
                    <thead>
                        <tr>
                            <th class="head_table">Numero</th>
                            <th class="head_table">Tipo</th>
                            <th class="head_table">Precio S/</th>
                            <th class="head_table">Estado</th>
                            <th class="head_table">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $mantenimiento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $habitacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr data-table="<?php echo e($habitacion->id_habitacion); ?>">
                            <td><div class="ui violet label"><?php echo e($habitacion->numero); ?></div></td>
                            <td><?php echo e($habitacion->tipo_habitacion->nombre); ?></td>
                            <td><?php echo e($habitacion->precio); ?></td>
                            <td>
                                <div class="ui yellow label"><?php echo e($habitacion->situacion); ?></div>
                            </td>
                            <td>                         
                                <div class="ui mini vertical green button button_activar_modal" title="Poner en disponible" data-id="<?php echo e($habitacion->id_habitacion); ?>">
                                    <div class="visible content"><i class="check icon"></i> Habilitar habitacion</div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table> 
            </div>
            <!-- end tab 1 -->

            
            <!-- start tab 2 -->
            <div class="ui bottom attached tab" data-tab="uno">
                <br><br>
                <div class="ui equal width grid">
                    <div class="row">
                         <div class="column">
                            <div class="ui action small input"  autocomplete="off">
                                <input type="text" id="buscar_habitacion_disponibles" placeholder="Numero de habitacion">
                                <div class="ui icon button" id="btn_buscar_habitacion_disponibles" title="Clic para buscar"><i class="search icon"></i></div>
                            </div> 
                        </div>
                        <div class="column export_files" style="text-align: right">
                            <select class="ui small input dropdown" id="tipo_habitacion_disponibles">
                                <option value="">Seleccione</option>
                                <option value="TODOS">Todos</option>
                                <?php $__currentLoopData = $tipo_habitacion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tipo->nombre); ?>"> <?php echo e(ucwords(mb_strtolower($tipo->nombre))); ?> </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>  
                        </div>
                    </div>
                </div>
                <table class="ui celled striped table" id="tabla_disponibles">
                    <thead>
                        <tr>
                            <th class="head_table">Numero</th>
                            <th class="head_table">Tipo</th>
                            <th class="head_table">Precio S/</th>
                            <th class="head_table">Estado</th>
                            <th class="head_table">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $disponibles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $habitacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr data-table="<?php echo e($habitacion->id_habitacion); ?>">
                            <td><div class="ui violet label"><?php echo e($habitacion->numero); ?></div></td>
                            <td><?php echo e($habitacion->tipo_habitacion->nombre); ?></td>
                            <td><?php echo e($habitacion->precio); ?></td>
                            <td>
                                <div class="ui green label"><?php echo e($habitacion->situacion); ?></div>
                            </td>
                            <td>                         
                                <div class="ui mini vertical orange button button_mantener_modal" title="Poner en mantenimiento"  data-id="<?php echo e($habitacion->id_habitacion); ?>">
                                    <div class="visible content"><i class="trash icon"></i> Poner en mantenimiento</div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table> 
            </div>
            <!-- end tab 2 -->

            <!-- start tab 3 -->
            <div class="ui bottom attached tab" data-tab="dos">
                <br><br>
                <div class="ui equal width grid">
                    <div class="row">
                         <div class="column">
                            <div class="ui action small input"  autocomplete="off">
                                <input type="text" id="buscar_habitacion_ocupadas" placeholder="Numero de habitacion">
                                <div class="ui icon button" id="btn_buscar_habitacion_ocupadas" title="Clic para buscar"><i class="search icon"></i></div>
                            </div> 
                        </div>
                        <div class="column export_files" style="text-align: right">
                            <select class="ui small input dropdown" id="tipo_habitacion_ocupadas">
                                <option value="">Seleccione</option>
                                <option value="TODOS">Todos</option>
                                <?php $__currentLoopData = $tipo_habitacion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tipo->nombre); ?>"> <?php echo e(ucwords(mb_strtolower($tipo->nombre))); ?> </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>  
                        </div>
                    </div>
                </div>
                <table class="ui celled striped table" id="tabla_ocupadas">
                    <thead>
                        <tr>
                            <th class="head_table">Numero</th>
                            <th class="head_table">Tipo</th>
                            <th class="head_table">Precio S/</th>
                            <th class="head_table">Estado</th>
                            <th class="head_table">Acciones</th> 
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $ocupadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $habitacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr data-table="<?php echo e($habitacion->id_habitacion); ?>">
                            <td><div class="ui violet label"><?php echo e($habitacion->numero); ?></div></td>
                            <td><?php echo e($habitacion->tipo_habitacion->nombre); ?></td>
                            <td><?php echo e($habitacion->precio); ?></td>
                            <td>
                                <div class="ui red label"><?php echo e($habitacion->situacion); ?></div>
                            </td>
                            <td>                         
                                <div class="ui mini vertical orange button button_mantener_modal" title="Poner en mantenimiento"  data-id="<?php echo e($habitacion->id_habitacion); ?>">
                                    <div class="visible content"><i class="trash icon"></i> Poner en mantenimiento</div>
                                </div>
                            </td> 
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table> 
            </div>
            <!-- end tab 3 -->




        </div>
    </div>

    <!--start delete modal -->
    <div class="ui small basic modal" id="mantenimiento_modal">
        <div class="ui icon header"><i class="trash alternate icon"></i>Poner en Mantenimiento</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere quiere poner en mantenimiento esta habitacion?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para poner en mantenimiento"> <i class="checkmark icon"></i>Proceder</div>
        </div>
    </div>
    <!--end delete modal -->

    <!--start delete modal -->
    <div class="ui small basic modal" id="activar_modal">
        <div class="ui icon header"><i class="check icon"></i>Habilitar Habitacion</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere habilitar esta habitacion?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para habilitar"> <i class="checkmark icon"></i>Habilitar</div>
        </div>
    </div>
    <!--end delete modal -->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/hospedar/listar.js')); ?>"></script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>